<?php

namespace App\Filament\Resources;

use App\Filament\Resources\BolsaDeTrabajoResource\Pages;
use App\Filament\Resources\BolsaDeTrabajoResource\RelationManagers;
use App\Models\BolsaDeTrabajo;
use App\Models\PerfilEmpresarial;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BolsaDeTrabajoResource extends Resource
{
    protected static ?string $model = BolsaDeTrabajo::class;

    protected static ?string $navigationIcon = 'heroicon-o-briefcase';
        
    protected static ?string $modelLabel = 'Oferta Laboral'; //Texto en singular

    protected static ?string $pluralModelLabel = 'Bolsa De Trabajo'; //Texto en plural

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('puesto')
                    ->label('Puesto de trabajo')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextArea::make('descripcion')
                    ->label('Descripción')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('salario')
                    ->label('Salario')
                    ->numeric()
                    ->inputMode('decimal'),
                Forms\Components\Select::make('empresa_id')
                    ->label('Empresa')
                    ->options(PerfilEmpresarial::pluck('nombre', 'id'))
                    ->required()
                    ->searchable(),
                 Forms\Components\Toggle::make('status')
                    ->label('Estatus (activar o desactivar oferta)')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                //
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBolsaDeTrabajos::route('/'),
            'create' => Pages\CreateBolsaDeTrabajo::route('/create'),
            'edit' => Pages\EditBolsaDeTrabajo::route('/{record}/edit'),
        ];
    }
}
