<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PerfilEmpresarialResource\Pages;
use App\Filament\Resources\PerfilEmpresarialResource\RelationManagers;
use App\Models\PerfilEmpresarial;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\FileUpload;

use App\Filament\Resources\PerfilEmpresarialResource\RelationManagers\ContactoClaveRelationManager;
use App\Models\ContactoClave;


use App\Models\TipoDeMembresia;
use Filament\Forms\Components\Select;

use App\Models\Categoria;
use Filament\Forms\Components\CheckboxList;
use Filament\Forms\Components\Section;

use Filament\Forms\Components\Grid;

use Filament\Forms\Components\Fieldset;

class PerfilEmpresarialResource extends Resource
{
    protected static ?string $model = PerfilEmpresarial::class;

    protected static ?string $navigationIcon = 'heroicon-o-identification';

    protected static ?string $modelLabel = 'Perfil Empresarial'; //Texto en singular

    protected static ?string $pluralModelLabel = 'Perfiles Empresariales'; //Texto en plural

    protected static ?string $navigationGroup = 'Perfiles empresariales';

    public static function form(Form $form): Form
    {
        return $form
            // Define el número de columnas del formulario
            ->schema([
                Forms\Components\TextInput::make('nombre')
                    ->required(),
                Forms\Components\TextInput::make('nombre_comercial')
                    ->maxLength(100),
                Forms\Components\TextInput::make('razon_social')
                    ->columnSpanFull()
                    ->maxLength(100),
                Forms\Components\TextInput::make('descripcion_breve')
                    ->maxLength(150)
                    ->helperText('Breve descripción de la empresa, máximo 150 caracteres')
                    ->columnSpanFull(),
                Forms\Components\Textarea::make('descripcion_detallada')
                    ->helperText('Descripción detallada de la empresa, máximo 300 caracteres')
                    ->maxLength(300)
                    ->rules(['max:300']) // backend
                    ->columnSpanFull(),
                
                FileUpload::make('logo_path')
                    ->label('Logo de la Empresa (Ajustar Imagen)')
                    ->image()
                    ->directory('logos')
                    ->maxSize(5024)
                    ->imageEditor()
                    ->imageCropAspectRatio('9:3')
                    ->acceptedFileTypes(['image/png', 'image/jpeg', 'image/jpg'])
                    ->required()
                    ->multiple(false),

                FileUpload::make('documentos')
                    ->label('Documentos en PDF')
                    ->acceptedFileTypes(['application/pdf'])
                    ->multiple()
                    ->maxFiles(10)
                    ->directory('pdfs')
                    ->storeFileNamesIn('nombres_documentos') // Almacena los nombres de los archivos en un campo JSON
                    ->downloadable()
                    ->previewable(true),

                Forms\Components\TextInput::make('pagina_web')
                    ->label('Página Web')
                    ->url()
                    ->placeholder('https://www.ejemplo.com')
                    ->maxLength(50),
                            
                Select::make('tipo_membresia_id')
                    ->required()
                    ->label('Tipo de Membresía')
                    ->options(TipoDeMembresia::pluck('nombre', 'id'))
                    ->searchable(),
                
                Forms\Components\TextInput::make('lada')->maxLength(3),
                Forms\Components\TextInput::make('telefono_oficina')->maxLength(10),

                Forms\Components\TextInput::make('email')
                    ->email()
                    ->maxLength(25),
                Forms\Components\Toggle::make('status')
                    ->label('Estatus (activar o desactivar)')
                    ->default(1)
                    ->required(),

               Section::make('Categorías')// Apartado para seleccionar categorías
                    ->collapsible()
                    ->schema([
                        CheckboxList::make('categorias') // Campo para seleccionar múltiples categorías
                            ->label('Selecciona categorías')
                            ->relationship('categorias', 'nombre')
                            ->columns(2)
                            ->reactive(), // Importante para que el campo sea observado por otros
                        Forms\Components\TextInput::make('otra_categoria')// Campo para especificar otra categoría
                            ->label('Especifique otra categoría')
                            ->placeholder('Ingrese el nombre de la categoría')
                            ->visible(fn (callable $get) => in_array(21, $get('categorias') ?? [])), // Visible solo si la categoría 21 está seleccionada (la categoría 21 es "Otra")
                    ])
                    ->collapsed(),
                Section::make('Acreditaciones, Registros y Certificaciones')// Apartado para seleccionar sectores de experiencia y conocimiento
                    ->collapsible()
                    ->schema([
                        CheckboxList::make('registros_acreditaciones_certificaciones') // Campo para seleccionar múltiples sectores de experiencia y conocimiento
                            ->label('Selecciona los registros, acreditaciones y certificaciones')
                            ->relationship('registros_acreditaciones_certificaciones', 'nombre') //Relacion nivel de Eloquent
                            ->columns(2)
                            ->reactive(), // Importante para que el campo sea observado por otros
                        Forms\Components\TextInput::make('otra_acreditacion')
                            ->label('Especifique otra Acreditacion, Registro o Certificacion ')
                            ->placeholder('Ingrese el nombre de la Acreditacion, Registro o Certificacion')
                            ->visible(fn (callable $get) => in_array(23, $get('registros_acreditaciones_certificaciones') ?? [])),
                    ])
                    ->collapsed(),
                Section::make('Sectores de Experiencia y Conocimiento')// Apartado para seleccionar sectores de experiencia y conocimiento
                    ->collapsible()
                    ->schema([
                        CheckboxList::make('sectores_de_experiencia_conocimiento') // Campo para seleccionar múltiples sectores de experiencia y conocimiento
                            ->label('Selecciona los registros, acreditaciones y certificaciones')
                            ->relationship('sectores_de_experiencia_conocimiento', 'nombre') //Relacion nivel de Eloquent
                            ->columns(2)
                            ->reactive(), // Importante para que el campo sea observado por otros
                        Forms\Components\TextInput::make('otra_sector')
                            ->label('Especifique otra Acreditacion, Registro o Certificacion ')
                            ->placeholder('Ingrese el nombre de la Acreditacion, Registro o Certificacion')
                            ->visible(fn (callable $get) => in_array(23, $get('sectores_de_experiencia_conocimiento') ?? [])),
                    ])
                    ->collapsed(),
                
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nombre')
                    ->numeric()
                    ->sortable()
                    ->searchable(),
                Tables\Columns\TextColumn::make('razon_social')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\ImageColumn::make('logo_path')
                    ->label('Logo'),
                Tables\Columns\TextColumn::make('tipoMembresia.nombre')// Relación con TipoDeMembresia a nivel de Eloquent
                    ->label('Tipo de Membresía')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\ToggleColumn::make('status')
                    ->label('Estatus'),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                Tables\Filters\TernaryFilter::make('status')
                    ->label('Activar')
                    ->placeholder('Todos')
                    ->trueLabel('Activos')
                    ->falseLabel('Inactivos'),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            ContactoClaveRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPerfilEmpresarials::route('/'),
            'create' => Pages\CreatePerfilEmpresarial::route('/create'),
            'edit' => Pages\EditPerfilEmpresarial::route('/{record}/edit'),
        ];
    }
}
