<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PrerregistroResource\Pages;
use App\Filament\Resources\PrerregistroResource\RelationManagers;
use App\Models\Prerregistro;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use pxlrbt\FilamentExcel\Actions\Tables\ExportBulkAction;

class PrerregistroResource extends Resource
{
    protected static ?string $model = Prerregistro::class;

    protected static ?string $navigationIcon = 'heroicon-o-clipboard-document';

    protected static ?string $modelLabel = 'Formulario de necesidades'; //Texto en singular

    protected static ?string $pluralModelLabel = 'Formularios de necesidades'; //Texto en plural

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('nombre_completo')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('nombre_empresa')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('email')
                    ->email()
                    ->required()
                    ->maxLength(255),
                Forms\Components\Toggle::make('permiso_imagen')
                    ->required(),
                Forms\Components\Toggle::make('fundador')
                    ->required(),
                Forms\Components\TextInput::make('alcance_geografico')
                    ->required(),
                Forms\Components\TextInput::make('servicios')
                    ->required(),
                Forms\Components\TextInput::make('necesidades')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nombre_completo')->sortable()->searchable(),
            Tables\Columns\TextColumn::make('nombre_empresa')->sortable()->searchable(),
            Tables\Columns\TextColumn::make('email')->sortable()->searchable(),
            Tables\Columns\IconColumn::make('permiso_imagen')->boolean(),
            Tables\Columns\IconColumn::make('fundador')->boolean(),

            // ✅ Esto convierte tu array JSON en etiquetas bonitas
            Tables\Columns\TagsColumn::make('alcance_geografico')
                ->label('Alcance geográfico'),

            Tables\Columns\TagsColumn::make('servicios')
                ->label('Servicios'),

            Tables\Columns\TagsColumn::make('necesidades')
                ->label('Necesidades'),

            Tables\Columns\TextColumn::make('created_at')
                ->dateTime('d/m/Y H:i')
                ->label('Fecha registro'),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\Action::make('enviar_email')
                    ->label('Enviar email')
                    ->icon('heroicon-o-envelope')
                    ->color('success')
                    ->disabled()
                        ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                    ExportBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPrerregistros::route('/'),
            //'create' => Pages\CreatePrerregistro::route('/create'),
            'edit' => Pages\EditPrerregistro::route('/{record}/edit'),
        ];
    }
}
