<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PublicidadPagadaResource\Pages;
use App\Filament\Resources\PublicidadPagadaResource\RelationManagers;
use App\Models\PublicidadPagada;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PublicidadPagadaResource extends Resource
{
    protected static ?string $model = PublicidadPagada::class;

    protected static ?string $navigationIcon = 'heroicon-o-film';

    protected static ?string $modelLabel = 'Publicidad Pagada'; //Texto en singular

    protected static ?string $pluralModelLabel = 'Publicidad Pagada'; //Texto en plural
    

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('titulo')
                    ->label('Título')
                    ->required()
                    ->maxLength(255),
                Forms\Components\FileUpload::make('image_path')
                    ->label('Imagen de la publicidad (Ajustar  al formato)')
                    ->directory('publicidad')
                    ->image()
                    ->required()
                    ->imageEditor() // Permite editar la imagen
                    ->imageCropAspectRatio('5:3') // Mantiene aspecto cuadrado
                    ,
                Forms\Components\TextInput::make('link')
                    ->label('URL (A donde redirige)')
                    ->url()
                    ->placeholder('https://www.ejemplo.com')
                    ->maxLength(100),
                Forms\Components\TextInput::make('tiempo')
                    ->numeric()
                    ->required()
                    ->minValue(1) // mínimo 1 segundo
                    ->maxValue(3600) 
                    ->label('Tiempo (en segundos)'),
                Forms\Components\Toggle::make('status')
                    ->label('Estatus (activar o desactivar)')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('titulo')
                    ->label('Título')
                    ->searchable(),
                Tables\Columns\ImageColumn::make('image_path')
                    ->label('Imagen de la publicidad'),
                Tables\Columns\TextColumn::make('tiempo')
                    ->label('Tiempo (en segundos)'),
                Tables\Columns\ToggleColumn::make('status')
                    ->label('Estatus'),

                // Tables\Columns\IconColumn::make('status')
                //     ->label('Estatus')
                //     ->boolean(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                 Tables\Filters\TernaryFilter::make('status')
                    ->label('Activar')
                    ->placeholder('Todos')
                    ->trueLabel('Activos')
                    ->falseLabel('Inactivos'),
                        ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPublicidadPagadas::route('/'),
            'create' => Pages\CreatePublicidadPagada::route('/create'),
            'edit' => Pages\EditPublicidadPagada::route('/{record}/edit'),
        ];
    }
}
