<?php

namespace App\Filament\Resources;

use App\Filament\Resources\RegistroAcreditacionCertificacionResource\Pages;
use App\Filament\Resources\RegistroAcreditacionCertificacionResource\RelationManagers;
use App\Models\RegistroAcreditacionCertificacion;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class RegistroAcreditacionCertificacionResource extends Resource
{
    protected static ?string $model = RegistroAcreditacionCertificacion::class;


    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static ?string $modelLabel = 'Registro, Acreditación o Certificación'; //Texto en singular

    protected static ?string $pluralModelLabel = 'Registros, Acreditaciónes y Certificaciónes'; //Texto en plural

    protected static ?string $navigationGroup = 'Perfiles empresariales';


    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('nombre')
                    ->required()
                    ->unique()
                    ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nombre')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Fecha de creación')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                // Tables\Columns\TextColumn::make('updated_at')
                //     ->dateTime()
                //     ->sortable()
                //     ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListRegistroAcreditacionCertificacions::route('/'),
            'create' => Pages\CreateRegistroAcreditacionCertificacion::route('/create'),
            'edit' => Pages\EditRegistroAcreditacionCertificacion::route('/{record}/edit'),
        ];
    }
    
    
}
