<?php

namespace App\Filament\Resources;

use App\Filament\Resources\RoleResource\Pages;
use App\Filament\Resources\RoleResource\RelationManagers;
use App\Models\Role;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\CheckboxList;
use Filament\Forms\Components\Section;
use Spatie\Permission\Models\Permission;
use App\Filament\Resources\RoleResource\RelationManagers\PermissionsRelationManager;
use Filament\Forms\Components\MultiSelect;
use Illuminate\Support\Str;

class RoleResource extends Resource
{
    protected static ?string $model = Role::class;

    protected static ?string $navigationIcon = 'heroicon-o-shield-check';

    protected static ?string $navigationGroup = 'Roles y Permisos';

    protected static ?string $modelLabel = 'Rol'; //Texto en singular

    protected static ?string $pluralModelLabel = 'Roles'; //Texto en plural

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label('Nombre del Rol')
                    ->required()
                    ->maxLength(255),
                Hidden::make('guard_name')
                    ->default('web')
                    
                    ->required(),
                MultiSelect::make('permissions')
                    ->label('Permisos')
                    ->relationship('permissions', 'name')
                    ->options(function () {
                        return Permission::query()
                            ->orderBy('category')
                            ->orderBy('name')
                            ->get()
                            ->mapWithKeys(fn (Permission $p) => [
                                $p->id => "{$p->name} ({$p->category})",
                            ])
                            ->toArray();
                            })
                            ->searchable()                // para buscar en la lista
                            ->preload()                   // carga todas las opciones al abrir
                            ->placeholder('Selecciona permisos')
                            ->helperText('Aquí ves nombre y categoría de cada permiso')
                            ->columnSpanFull()            // ocupa todo el ancho si quieres
                            ->multiple()                 // habilita selección múltiple

                                ]);
                            }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //RelationManagers\PermissionsRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListRoles::route('/'),
            'create' => Pages\CreateRole::route('/create'),
            'edit' => Pages\EditRole::route('/{record}/edit'),
        ];
    }
    
}
