<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SectoresDeExperienciaConocimientoResource\Pages;
use App\Filament\Resources\SectoresDeExperienciaConocimientoResource\RelationManagers;
use App\Models\SectoresDeExperienciaConocimiento;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class SectoresDeExperienciaConocimientoResource extends Resource
{
    protected static ?string $model = SectoresDeExperienciaConocimiento::class;

    protected static ?string $navigationIcon = 'heroicon-o-clipboard-document-list';

    protected static ?string $modelLabel = 'Sector de Experiencia y Conocimiento'; //Texto en singular

    protected static ?string $pluralModelLabel = 'Sectores de Experiencia y Conocimiento'; //Texto en plural

    protected static ?string $navigationGroup = 'Perfiles empresariales';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('nombre')
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nombre')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Fecha de creación')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                // Tables\Columns\TextColumn::make('updated_at')
                //     ->dateTime()
                //     ->sortable()
                //     ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSectoresDeExperienciaConocimientos::route('/'),
            'create' => Pages\CreateSectoresDeExperienciaConocimiento::route('/create'),
            'edit' => Pages\EditSectoresDeExperienciaConocimiento::route('/{record}/edit'),
        ];
    }
    
}
