<?php

namespace App\Filament\Resources;

use App\Filament\Resources\TipoDeMembresiaResource\Pages;
use App\Filament\Resources\TipoDeMembresiaResource\RelationManagers;
use App\Models\Permiso;
use App\Models\TipoDeMembresia;
use Filament\Forms;
use Filament\Forms\Components\CheckboxList;
use Filament\Forms\Components\MultiSelect;
use Filament\Forms\Components\Section;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;


class TipoDeMembresiaResource extends Resource
{
    protected static ?string $model = TipoDeMembresia::class;

    protected static ?string $navigationIcon = 'heroicon-o-banknotes';

    protected static ?string $modelLabel = 'Membresía'; //Texto en singular

    protected static ?string $pluralModelLabel = 'Tipos De Membresía'; //Texto en plural

    protected static ?string $navigationGroup = 'Membresias y Permisos';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('nombre')
                    ->required()
                    ->maxLength(255),
                Section::make('Permisos disponibles')
    ->description('Selecciona el acceso al directorio que tendrá esta membresía.')
    ->schema([
        CheckboxList::make('permisos')
            ->label('Permisos')
            ->relationship('permisos', 'nombre')
            ->options(function () {
                return \App\Models\Permiso::query()
                    ->orderBy('categoria')
                    ->orderBy('nombre')
                    ->get()
                    ->mapWithKeys(fn ($p) => [
                        $p->id => "{$p->nombre} ({$p->categoria})",
                    ])
                    ->toArray();
            })
            ->columns(2)
            ->helperText('Selecciona que podra ver cada usuario')
            ->columnSpanFull(),
           
    ])
    ->collapsible() // opcional: permite plegar la sección
    ->columns(1),
     Forms\Components\TextInput::make('precio')
                    ->numeric()
                    ->step(0.01)
                    ->required()
                    ->prefix('$'),

                
                                ])
                                ;
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nombre')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListTipoDeMembresias::route('/'),
            'create' => Pages\CreateTipoDeMembresia::route('/create'),
            'edit' => Pages\EditTipoDeMembresia::route('/{record}/edit'),
        ];
    }
}
