<?php

namespace App\Filament\Resources;

use App\Filament\Resources\WebinarResource\Pages;
use App\Filament\Resources\WebinarResource\RelationManagers;
use App\Models\Webinar;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class WebinarResource extends Resource
{
    protected static ?string $model = Webinar::class;

    protected static ?string $navigationIcon = 'heroicon-o-academic-cap';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('titulo')
                    ->label('Título')
                    ->required()
                    ->maxLength(255),
                Forms\Components\Textarea::make('descripcion')
                    ->label('Descripción')
                    ->required()
                    ->rows(3),
                Forms\Components\DatePicker::make('fecha')
                    ->required(),
                Forms\Components\TimePicker::make('hora')
                    ->required(),
                Forms\Components\TextInput::make('link')
                    ->label('Enlace')
                    ->required()
                    ->url()
                    ->maxLength(255),
                Forms\Components\TextInput::make('nombre_presentador')
                    ->required()
                    ->maxLength(255),
                Forms\Components\FileUpload::make('image_url')
                    ->label('Imagen del conversando con... (Ajustar  al formato)')
                    ->image()
                    ->directory('webinars')
                    ->required()
                    ->imageEditor() // Permite editar la imagen
                    ->imageCropAspectRatio('4:5') // Mantiene aspecto cuadrado
                    ,
                Forms\Components\Select::make('status')
                    ->label('Estatus')
                    ->required()
                    ->options([
                        'Programado' => 'Programado',
                        'En Vivo' => 'En Vivo',
                        'Finalizado' => 'Finalizado',
                        'Candelado' => 'Candelado',
                    ])
                    ->native(false),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nombre_presentador'),
                Tables\Columns\TextColumn::make('titulo')->limit(30)->searchable(),
                //Tables\Columns\TextColumn::make('descripcion')->limit(50),
                Tables\Columns\TextColumn::make('fecha')->date()->sortable(),
                Tables\Columns\TextColumn::make('hora')->sortable(),
                Tables\Columns\ImageColumn::make('image_url')->circular(),
                Tables\Columns\BadgeColumn::make('status')
                    ->colors([
                        'warning' => 'Programado',
                        'success' => 'En Vivo',
                        'gray' => 'Finalizado',
                        'danger' => 'Candelado',
                    ]),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Creado')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->label('Actualizado')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('link')->label('Enlace'),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListWebinars::route('/'),
            'create' => Pages\CreateWebinar::route('/create'),
            'edit' => Pages\EditWebinar::route('/{record}/edit'),
        ];
    }
}
