<?php

namespace App\Http\Controllers;

use App\Models\Comentario;
use App\Models\Post;
use Illuminate\Http\Request;

class ComentarioController extends Controller
{
    public function store(Request $request)
{
    $request->validate([
        'post_id' => 'required|exists:posts,id',
        'content' => 'required|string|max:500'
    ]);

    $comentario = Comentario::create([
        'user_id' => auth()->id(),
        'post_id' => $request->post_id,
        'content' => $request->content,
    ]);

    // Devuelve una vista parcial con solo el nuevo comentario
    return view('comentarios._comentario', compact('comentario'));
}

    public function loadMore(Request $request)
    {
        $postId = $request->post_id;
        $offset = $request->offset ?? 0;
        $limit = 5;

        $comentarios = Comentario::with('user')
            ->where('post_id', $postId)
            ->latest()
            ->skip($offset)
            ->take($limit)
            ->get();

        return view('components.comentarios-parciales', compact('comentarios'))->render();
    }
}
