<?php

namespace App\Http\Controllers;

use App\Models\PerfilEmpresarial;
use Illuminate\Http\Request;

class EmpresasController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $empresas = PerfilEmpresarial::with('contactosClave','tipoMembresia')->paginate();
        //return $empresas;
        return view('empresas.index', compact('empresas'));
    }

    public function suscripcion()
    {
        //return $empresas;
        return view('suscripciones.suscripcion');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(PerfilEmpresarial $perfilEmpresarial)
    {
        //$empresa = $perfilEmpresarial->load('contactosClave', 'tipoMembresia');
        $perfilEmpresarial->load('registros_acreditaciones_certificaciones','sectores_de_experiencia_conocimiento','categorias'); // Cargar relaciones
        //return $perfilEmpresarial;
        return view('empresas.show', compact('perfilEmpresarial'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(PerfilEmpresarial $perfilEmpresarial)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PerfilEmpresarial $perfilEmpresarial)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PerfilEmpresarial $perfilEmpresarial)
    {
        //
    }
    public function buscarFormulario()
    {
        return view('perfiles.buscar', [
            'categorias' => \App\Models\Categoria::all(),
            'rac' => \App\Models\RegistroAcreditacionCertificacion::all(),
            'sectores' => \App\Models\SectoresDeExperienciaConocimiento::all(),
        ]);
    }
    public function resultados(Request $request)
{
    $query = \App\Models\PerfilEmpresarial::query();

    if ($request->filled('nombre')) {
        $query->where('nombre', 'like', '%' . $request->nombre . '%');
    }

    if ($request->filled('categoria_id')) {
        $query->whereHas('categorias', function ($q) use ($request) {
            $q->where('categoria_id', $request->categoria_id);
        });
    }

    if ($request->filled('reg_acr_cer_id')) {
        $query->whereHas('registros_acreditaciones_certificaciones', function ($q) use ($request) {
            $q->where('reg_acr_cer_id', $request->reg_acr_cer_id);
        });
    }

    if ($request->filled('sector_id')) {
        $query->whereHas('sectores_de_experiencia_conocimiento', function ($q) use ($request) {
            $q->where('sector_de_experiencia_y_conocimiento_id', $request->sector_id);
        });
    }

    $empresas = $query->with(['categorias', 'registros_acreditaciones_certificaciones', 'sectores_de_experiencia_conocimiento', 'contactosClave', 'tipoMembresia'])
                      ->paginate(10)
                      ->appends($request->all()); // Mantiene filtros en la paginación

    return view('empresas.index', compact('empresas'));
}



}
