<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Post;

class PostController extends Controller
{
    public function index(Request $request)
{
    $query = Post::with('user', 'temas')
                    ->withCount('comentarios');

    // Si se envió una categoría en la URL (?categoria=3)
    if ($request->filled('tema')) {
        $query->whereHas('temas', function ($q) use ($request) {
            $q->where('temas.id', $request->tema);
        });
    }

    $posts = $query->latest()->paginate(3);

    return view('posts.index', compact('posts'));
}
    public function show(Post $post)
    {
        return view('posts.show', compact('post'));
    }
    public function welcome()
    {
        $posts = Post::with('user')->latest()->paginate(2);
        //return $posts;
        return view('welcome', compact('posts'));
    }
    public function like(Post $post)
    {
    $post->increment('likes');
    return;
    }

    public function store()
    {
        
    }
}
