<?php

namespace App\Http\Controllers;

use App\Models\Prerregistro;
use Illuminate\Http\Request;

class PrerregistroController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
         // Validación de datos
        $validated = $request->validate([
            'nombre_completo'   => 'required|string|max:255',
            'nombre_empresa'    => 'required|string|max:255',
            'email'             => 'required|email|unique:prerregistros,email',
            'permiso_imagen'    => 'required|boolean',
            'fundador'          => 'required|boolean',
            'alcance_geografico'=> 'required|array', // debe llegar como array
            'servicios'         => 'required|array',
            'necesidades'       => 'required|array',
        ]);

        // Guardar en la base de datos
        $prerregistro = Prerregistro::create([
            'nombre_completo'   => $validated['nombre_completo'],
            'nombre_empresa'    => $validated['nombre_empresa'],
            'email'             => $validated['email'],
            'permiso_imagen'    => $validated['permiso_imagen'],
            'fundador'          => $validated['fundador'],
            'alcance_geografico'=> $validated['alcance_geografico'],
            'servicios'         => $validated['servicios'],
            'necesidades'       => $validated['necesidades'],
        ]);

        // Redirige con mensaje de éxito
        return redirect()->route('prerregistro-final');
    }
}
