<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckMembresia
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
         $user = $request->user();

        // Si no hay usuario autenticado, redirigir
        if (!$user) {
            return redirect()->route('login')->with('error', 'Debes iniciar sesión.');
        }

        // Solo permitir a usuarios con estas membresías
        $permitidas = ['Premium', 'Essentials', 'Basics'];

        if (!in_array($user->membresia->nombre ?? '', $permitidas)) {
            return redirect()->route('welcome')->with('error', 'No tienes acceso a la bolsa de trabajo.');
        }

        return $next($request);
    }
}
