<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Categoria extends Model
{
    protected $table = 'categorias';

    protected $fillable = [
        'nombre',
    ];
    // Relación muchos a muchos con PerfilEmpresarial (tabla pivote: categoria_perfil)
    public function perfilesEmpresariales()
    {
        return $this->belongsToMany(PerfilEmpresarial::class, 'categoria_perfil', 'categoria_id', 'perfil_empresarial_id');
    }

    // Relación muchos a muchos con Post (tabla pivote: post_categoria)
    public function posts()
    {
        return $this->belongsToMany(Post::class, 'post_categoria', 'categoria_id', 'post_id');
    }
}
