<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Noticia extends Model
{
    protected $table = 'noticias';

    protected $fillable = [
        'user_id',
        'title',
        'content',
        'image_path',
        'resumen',
        'status',
        'published_at',
    ];

    protected $casts = [
    'published_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
