<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PerfilEmpresarial extends Model
{
    protected $table = 'perfiles_empresariales';

    protected $fillable = [
        'nombre',
        'pagina_web',
        'lada',
        'telefono_oficina',
        'email',
        'nombre_comercial',
        'razon_social',
        'descripcion_breve',
        'descripcion_detallada',
        'status',
        'tipo_membresia_id',
        'logo_path',
        'documentos', // Las rutas de los documentos se almacenarán en formato JSON
        'nombres_documentos', // Nombres de los documentos para mostrar en la interfaz

    ];

    protected $casts = [
    'documentos' => 'array', // Para almacenar las rutas de los documentos en formato JSON
    'nombres_documentos' => 'array', // Para almacenar los nombres de los documentos en formato JSON
    ];

    // Relación muchos a muchos con Categoria (tabla intermedia: categoria_perfil)
    public function categorias()
    {
        return $this->belongsToMany(Categoria::class, 'categoria_perfil', 'perfil_empresarial_id', 'categoria_id');
    }
    // Relación muchos a muchos con registros_acreditaciones_certificaciones (tabla intermedia: registros_acreditaciones_certificaciones_perfil)
    public function registros_acreditaciones_certificaciones()
    {
        return $this->belongsToMany(RegistroAcreditacionCertificacion::class, 'registros_acreditaciones_certificaciones_perfiles', 'perfil_empresarial_id', 'reg_acr_cer_id');
    }
    // Relación muchos a muchos con sectores_de_experiencia_conocimiento (tabla intermedia: sector_de_experiencia_y_conocimiento_perfil)
    public function sectores_de_experiencia_conocimiento()
    {
        return $this->belongsToMany(SectoresDeExperienciaConocimiento::class, 'sectores_de_experiencia_conocimiento_perfil', 'perfil_empresarial_id', 'sector_de_experiencia_y_conocimiento_id');
    }
    
    public function tipoMembresia()
    {
        return $this->belongsTo(TipoDeMembresia::class, 'tipo_membresia_id');
    }

    public function contactosClave()
    {
        return $this->hasMany(\App\Models\ContactoClave::class);
    }

    public function bolsaDeTrabajo()
    {
        return $this->hasMany(BolsaDeTrabajo::class);
    }
    

    

}
