<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Post extends Model
{
    protected $fillable = [
        'title', 
        'content', 
        'likes',
        'published_at', 
        'user_id', 
        'images_path'
    ];
    
    protected $casts = [
        'published_at' => 'datetime',
        'images_path' => 'array', // JSON de rutas de imagenes
    ];
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function temas()
    {
        return $this->belongsToMany(Tema::class, 'post_tema', 'post_id', 'tema_id');
    }
    public function comentarios()
    {
        return $this->hasMany(Comentario::class)->latest();
    }
}
