<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RegistroAcreditacionCertificacion extends Model
{
    protected $table = 'registros_acreditaciones_certificaciones';

    protected $fillable = [
        'nombre',
    ];

    // Relación muchos a muchos con PerfilEmpresarial (tabla pivote: categoria_perfil)
    public function perfilesEmpresariales()
    {
        return $this->belongsToMany(PerfilEmpresarial::class, 'registros_acreditaciones_certificaciones_perfiles', 'reg_acr_cer_id', 'perfil_empresarial_id');
    }
}
