<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SectoresDeExperienciaConocimiento extends Model
{
    protected $table = 'sectores_de_experiencia_conocimiento';

    protected $fillable = [
        'nombre',
    ];

    // Relación muchos a muchos con PerfilEmpresarial (tabla pivote: categoria_perfil)
    public function perfilesEmpresariales()
    {
        return $this->belongsToMany(PerfilEmpresarial::class, 'sectores_de_experiencia_conocimiento_perfil', 'perfil_empresarial_id', 'sector_de_experiencia_y_conocimiento_id');
    }
}
