<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class TipoDeMembresia extends Model
{
    protected $table = 'tipo_de_membresias';

    protected $fillable = [
        'nombre',
        'caracteristicas',
        'precio',
    ];

    


    public function user(): HasOne
    {
        return $this->hasOne(User::class, 'tipo_membresia_id', 'id');
    }

    public function permisos()
    {
        return $this->belongsToMany(Permiso::class, 'permisos_membresias', 'tipo_membresia_id', 'permiso_id');
    }

    public function perfilesEmpresariales()
    {
        return $this->hasMany(PerfilEmpresarial::class, 'tipo_membresia_id');
    }

    
}
