<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Video extends Model
{
    protected $fillable = ['descripcion', 'youtube_url'];

    public function getYoutubeEmbedUrlAttribute()
    {
        // Convierte URL normal en embed (YouTube)
        preg_match('/(?:v=|be\/)([a-zA-Z0-9_-]{11})/', $this->youtube_url, $matches);
        return isset($matches[1]) ? 'https://www.youtube.com/embed/' . $matches[1] : null;
    }
}
