<?php

namespace App\Policies;

use App\Models\BolsaDeTrabajo;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class BolsaDeTrabajoPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('ver_cualquier_trabajo');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, BolsaDeTrabajo $bolsaDeTrabajo): bool
    {
        return $user->can('ver_trabajo');
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->can('crear_trabajo');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, BolsaDeTrabajo $bolsaDeTrabajo): bool
    {
        return $user->can('editar_trabajo');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, BolsaDeTrabajo $bolsaDeTrabajo): bool
    {
        return $user->can('eliminar_trabajo');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, BolsaDeTrabajo $bolsaDeTrabajo): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, BolsaDeTrabajo $bolsaDeTrabajo): bool
    {
        return false;
    }
}
