<?php

namespace App\Policies;

use App\Models\Permiso;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class PermisoPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('ver_cualquier_permiso_membresias');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Permiso $permiso): bool
    {
        return $user->can('ver_permiso_membresias');
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->can('crear_permiso_membresias');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Permiso $permiso): bool
    {
        return $user->can('editar_permiso_membresias');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Permiso $permiso): bool
    {
        return $user->can('eliminar_permiso_membresias');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Permiso $permiso): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Permiso $permiso): bool
    {
        return false;
    }
}
