<?php

namespace App\Policies;

use App\Models\Prerregistro;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class PrerregistroPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('ver_cualquier_prerregistro');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Prerregistro $prerregistro): bool
    {
        return $user->can('ver_prerregistro');
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->can('crear_prerregistro');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Prerregistro $prerregistro): bool
    {
        return $user->can('editar_prerregistro');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Prerregistro $prerregistro): bool
    {
        return $user->can('eliminar_prerregistro');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Prerregistro $prerregistro): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Prerregistro $prerregistro): bool
    {
        return false;
    }
}
