<?php

namespace App\Policies;

use App\Models\PublicidadPagada;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class PublicidadPagadaPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('ver_cualquier_publicidad_pagada');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, PublicidadPagada $publicidadPagada): bool
    {
        return $user->can('ver_publicidad_pagada');
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
       return $user->can('crear_publicidad_pagada');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, PublicidadPagada $publicidadPagada): bool
    {
        return $user->can('editar_publicidad_pagada');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, PublicidadPagada $publicidadPagada): bool
    {
        return $user->can('eliminar_publicidad_pagada');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, PublicidadPagada $publicidadPagada): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, PublicidadPagada $publicidadPagada): bool
    {
        return false;
    }
}
