<?php

namespace App\Policies;

use App\Models\Tema;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class TemaPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('ver_cualquier_tema');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Tema $tema): bool
    {
        return $user->can('ver_tema');
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->can('crear_tema');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Tema $tema): bool
    {
        return $user->can('editar_tema');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Tema $tema): bool
    {
        return $user->can('eliminar_tema');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Tema $tema): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Tema $tema): bool
    {
        return false;
    }
}
