<?php

namespace App\Providers;

use App\Models\Categoria;
use App\Models\Noticia;
use App\Models\Post;
use App\Models\Tema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        View::composer('components.partials.sidebar', function ($view) {
            // Últimas 3 noticias
            $ultimasNoticias = Noticia::orderBy('published_at', 'desc')->take(3)->get();

            // Categorías populares (top 4)
            $categoriasPopulares = Tema::withCount('posts')
                ->orderByDesc('posts_count')
                ->take(4)
                ->get();

            // Otras categorías (excepto las populares)
            $otrasCategorias = Tema::withCount('posts')
                ->whereNotIn('id', $categoriasPopulares->pluck('id'))
                ->orderBy('nombre')
                ->get();

            $view->with([
                'ultimasNoticias' => $ultimasNoticias,
                'categoriasPopulares' => $categoriasPopulares,
                'otrasCategorias' => $otrasCategorias,
            ]);
        });
    }
}
