<?php

namespace App\View\Components;

use App\Models\Noticia;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class RecentNews extends Component
{
    public $noticias;
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        // Traer las últimas 5 noticias
        $this->noticias = Noticia::where('status', 1)
            ->orderBy('published_at', 'desc')
            ->get();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.recent-news');
    }
}
