<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('perfiles_empresariales', function (Blueprint $table) {
            $table->id();
            $table->string('nombre',100);
            $table->string('nombre_comercial',100)->nullable();
            $table->string('pagina_web',50)->nullable();
            $table->string('lada',3)->nullable();
            $table->string('telefono_oficina',10)->nullable();
            $table->string('email',25)->nullable();
            $table->string('razon_social',100)->nullable();
            $table->text('descripcion_breve',150)->nullable();
            $table->text('descripcion_detallada',300)->nullable();

            $table->boolean('status');

            $table->string('logo_path');

            $table->json('documentos')->nullable(); // Las rutas de los documentos se almacenarán en formato JSON
            $table->json('nombres_documentos')->nullable();
            
            $table->unsignedBigInteger('tipo_membresia_id');
            $table->foreign('tipo_membresia_id')
                ->references('id')
                ->on('tipo_de_membresias')
                ->onDelete('cascade');

            

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('perfiles_empresariales');
    }
};
