<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contactos_clave', function (Blueprint $table) {
            $table->id();
            $table->tinyText('nombre');
            $table->tinyText('apellidos');
            $table->tinyText('puesto_departamento');
            $table->tinyText('email');
            $table->char('lada_telefono', 3);
            $table->char('telefono', 10);
            $table->tinyText('pagina_web')->nullable();
            $table->unsignedBigInteger('perfil_empresarial_id');
            $table->string('logo_path')->nullable();

            $table->foreign('perfil_empresarial_id')
                ->references('id')
                ->on('perfiles_empresariales')
                ->onDelete('cascade');
                
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contacto_clave');
    }
};
