<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {//Tabla intermedia entre perfiles empresariales y categorías
        Schema::create('categoria_perfil', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('perfil_empresarial_id');
            $table->unsignedBigInteger('categoria_id');

            $table->foreign('perfil_empresarial_id')
                ->references('id')
                ->on('perfiles_empresariales')
                ->onDelete('cascade');

            $table->foreign('categoria_id')
                ->references('id')
                ->on('categorias')
                ->onDelete('cascade');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categoria_perfil');
    }
};
