<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('registros_acreditaciones_certificaciones_perfiles', function (Blueprint $table) {
    $table->id();

    $table->unsignedBigInteger('perfil_empresarial_id');
    $table->unsignedBigInteger('reg_acr_cer_id');

    
    $table->foreign('perfil_empresarial_id', 'fk_perfil')
        ->references('id')
        ->on('perfiles_empresariales')
        ->onDelete('cascade');

    
    $table->foreign('reg_acr_cer_id', 'fk_rac')
        ->references('id')
        ->on('registros_acreditaciones_certificaciones')
        ->onDelete('cascade');

    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        
        Schema::dropIfExists('registros_acreditaciones_certificaciones_perfiles');
    }
};
