<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sectores_de_experiencia_conocimiento_perfil', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('perfil_empresarial_id');
            $table->unsignedBigInteger('sector_de_experiencia_y_conocimiento_id');

            $table->foreign('perfil_empresarial_id', 'fk_perfil_exp_con')
                ->references('id')
                ->on('perfiles_empresariales')
                ->onDelete('cascade');

            $table->foreign('sector_de_experiencia_y_conocimiento_id', 'fk_sector_exp_con')
                ->references('id')
                ->on('sectores_de_experiencia_conocimiento')
                ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sectores_de_experiencia_conocimiento_perfil');
    }
};
