<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('post_tema', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('post_id');

            $table->unsignedBigInteger('tema_id');

            // Relaciones
            $table->foreign('post_id')->references('id')->on('posts')->onDelete('cascade');
            $table->foreign('tema_id')->references('id')->on('temas')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('post_categoria');
    }
};
