<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('webinars', function (Blueprint $table) {
            $table->id();
            $table->string('titulo');
            $table->string('descripcion');
            //Fecha y hora del webinar
            $table->date('fecha');
            $table->time('hora');
            $table->string('link');

            //Datos del presentador
            $table->string('nombre_presentador');
            $table->string('image_url');
            //Status del webinar
            $table->enum('status', ['Programado', 'En Vivo', 'Finalizado', 'Candelado'])->default('Programado');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('webinars');
    }
};
