<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bolsa_de_trabajos', function (Blueprint $table) {
            $table->id();
            $table->string('puesto');
            $table->string('descripcion');
            $table->decimal('salario')->nullable();

            $table->boolean('status');

            $table->unsignedBigInteger('empresa_id');

            $table->foreign('empresa_id')
                ->references('id')
                ->on('perfiles_empresariales')
                ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bolsa_de_trabajos');
    }
};
