<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // En este seeder se generan los datos de prueba para las tablas(fuertes) de la base de datos.

        //Data para la tabla de categorias
        DB::table('categorias')->insert([
            ['nombre' => 'Propietario de un proyecto de reducción/captura de carbono', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Empresa que requiere calcular su inventario de huella de carbono', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Empresa que reporta al RENE', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Empresa que pertenece al SCE', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Empresa cuyo objetivo es ser carbono neutral/net zero', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Desarrollo/origen de proyectos de reducción/captura de carbono', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Consultor de proyectos de reducción/captura de carbono', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Consultor de inventarios de huella de carbono', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Consultor en carbono neutralidad/net zero', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Consultor en elaboración de política climática', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Proveedor de tecnologías y/o soluciones climáticas', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Estándar de carbono', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Gobierno / Elaboración de Política Pública climática', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Organismo de Validación (auditoría)', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Organismo de Verificación (auditoría)', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Venta de créditos de carbono propios', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Compra de créditos de carbono para compensar/neutralizar mis emisiones', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Comercialización de créditos de carbono (trading)', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Investigación climática/Academia', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Asociación/clúster', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Otro (especifique)', 'created_at' => now(), 'updated_at' => now()],
        ]);
        //Data para la tabla de tipo_de_membresias
        DB::table('tipo_de_membresias')->insert([
    [
        'nombre' => 'Founder',
        'caracteristicas' => json_encode([]),
        'created_at' => now(),
        'updated_at' => now()
    ],
    [
        'nombre' => 'Premium',
        'caracteristicas' => json_encode([
            'puede_hacer' => [
                ['valor' => 'Acceso a contenido Especializado'],
                ['valor' => 'Presencia en Logo Wall'],
                ['valor' => 'Directorio - presencia'],
                ['valor' => 'Oportunidades - presencia'],
                ['valor' => 'Bolsa de trabajo - presencia'],
                ['valor' => 'Noticias / Artículos'],
                ['valor' => 'Cápsulas'],
            ]
        ]),
        'created_at' => now(),
        'updated_at' => now()
    ],
    [
        'nombre' => 'Essentials',
        'caracteristicas' => json_encode([
            'puede_ver' => [
                ['valor' => 'Noticias / Artículos'],
                ['valor' => 'Cápsulas'],
            ],
            'puede_hacer' => [
                ['valor' => 'Acceso a contenido Especializado'],
                ['valor' => 'Presencia en Logo Wall'],
                ['valor' => 'Directorio - presencia'],
                ['valor' => 'Oportunidades - presencia'],
                ['valor' => 'Bolsa de trabajo - presencia'],
            ]
        ]),
        'created_at' => now(),
        'updated_at' => now()
    ],
    [
        'nombre' => 'Basics',
        'caracteristicas' => json_encode([
            'puede_ver' => [
                ['valor' => 'Directorio - consulta'],
                ['valor' => 'Oportunidades - consulta'],
                ['valor' => 'Bolsa de trabajo - consulta'],
                ['valor' => 'Noticias / Artículos - consulta'],
                ['valor' => 'Cápsulas - consulta'],
            ],
            'puede_hacer' => [
                ['valor' => 'Acceso a contenido Especializado'],
                ['valor' => 'Presencia en Logo Wall'],
            ]
        ]),
        'created_at' => now(),
        'updated_at' => now()
    ],
]);

        //Data para la tabla de registros_acreditaciones_certificaciones
        DB::table('registros_acreditaciones_certificaciones')->insert([
            ['nombre' => 'UNFCCC CDM', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'UNFCCC Paris Agreement Crediting Mechanism Article 6.4', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Gold Standard for the Global Goals', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'VERRA/VCS', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Climate Action Reserve (CAR)', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'CERCARBONO', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'BioCarbon Standard', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'puro.earth', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Plan Vivo Foundation', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Global Carbon Council', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'GHG Protocol', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Entidad Mexicana de Acreditación (ema)', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'SEMARNAT/PROFEPA', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'ANSI National Accreditation Board (ANAB)', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'ISO 14064-1', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'ISO 14064-2', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'ISO 14064-3', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'ISO 14065', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'ISO 14066', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'ISO 14067', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'ISO 50001', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'ISO 9001', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Otro (especifique)', 'created_at' => now(), 'updated_at' => now()],
        ]);
        //Data para la tabla de sectores_de_experiencia_conocimiento
        DB::table('sectores_de_experiencia_conocimiento')->insert([
            ['nombre' => 'Industria energética (fuentes no renovables)', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Energías renovables', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Distribución de energía', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Demanda de energía', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Eficiencia energética', 'created_at' => now(), 'updated_at' => now()],

            ['nombre' => 'Industria manufacturera', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Industria química', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Construcción', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Transporte', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Minería / producción de minerales', 'created_at' => now(), 'updated_at' => now()],

            ['nombre' => 'Producción de metales', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Emisiones fugitivas derivadas de combustibles (sólidos, petróleo y gas)', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Emisiones fugitivas derivadas de la producción y consumo de halocarbonos y hexafloruro de azufre', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Uso de disolventes', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Manejo y disposición de residuos / producción de minerales', 'created_at' => now(), 'updated_at' => now()],

            ['nombre' => 'Manejo de ganado, fermentación entérica y estiércol', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Biogás/Biometano', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Biochar', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Biomasa o biocombustible líquido', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Producción y/o uso de biocombustible', 'created_at' => now(), 'updated_at' => now()],

            ['nombre' => 'Forestación y reforestación, fermentación entérica y estiércol', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Agricultura y uso de suelo', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Captura y almacenamiento de carbono', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Comercio', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Servicios', 'created_at' => now(), 'updated_at' => now()],
            ['nombre' => 'Otro (especifique)', 'created_at' => now(), 'updated_at' => now()],




        ]);
        
    }
}
