<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //Permisos "Usuarios"
        Permission::create(['name' => 'crear_usuario', 'guard_name' => 'web', 'category' => 'Usuarios'])->syncRoles('admin');
        Permission::create(['name' => 'editar_usuario', 'guard_name' => 'web', 'category' => 'Usuarios'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_usuario', 'guard_name' => 'web', 'category' => 'Usuarios'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_cualquier_usuario', 'guard_name' => 'web', 'category' => 'Usuarios'])->syncRoles('admin');
        Permission::create(['name' => 'ver_usuario', 'guard_name' => 'web', 'category' => 'Usuarios'])->syncRoles('admin');
        Permission::create(['name' => 'ver_cualquier_usuario', 'guard_name' => 'web', 'category' => 'Usuarios'])->syncRoles('admin');

        //Permisos "Roles"
        Permission::create(['name' => 'crear_rol', 'guard_name' => 'web', 'category' => 'Roles'])->syncRoles('admin');
        Permission::create(['name' => 'editar_rol', 'guard_name' => 'web', 'category' => 'Roles'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_rol', 'guard_name' => 'web', 'category' => 'Roles'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_cualquier_rol', 'guard_name' => 'web', 'category' => 'Roles'])->syncRoles('admin');
        Permission::create(['name' => 'ver_rol', 'guard_name' => 'web', 'category' => 'Roles'])->syncRoles('admin');
        Permission::create(['name' => 'ver_cualquier_rol', 'guard_name' => 'web', 'category' => 'Roles'])->syncRoles('admin');

        //Permisos "Permisos"
        Permission::create(['name' => 'crear_permiso', 'guard_name' => 'web', 'category' => 'Permisos'])->syncRoles('admin');
        Permission::create(['name' => 'editar_permiso', 'guard_name' => 'web', 'category' => 'Permisos'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_permiso', 'guard_name' => 'web', 'category' => 'Permisos'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_cualquier_permiso', 'guard_name' => 'web', 'category' => 'Permisos'])->syncRoles('admin');
        Permission::create(['name' => 'ver_permiso', 'guard_name' => 'web', 'category' => 'Permisos'])->syncRoles('admin');
        Permission::create(['name' => 'ver_cualquier_permiso', 'guard_name' => 'web', 'category' => 'Permisos'])->syncRoles('admin');

        //Permisos "categorias"
        Permission::create(['name' => 'crear_categoria', 'guard_name' => 'web', 'category' => 'Categorias'])->syncRoles('admin');
        Permission::create(['name' => 'editar_categoria', 'guard_name' => 'web', 'category' => 'Categorias'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_categoria', 'guard_name' => 'web', 'category' => 'Categorias'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_cualquier_categoria', 'guard_name' => 'web', 'category' => 'Categorias'])->syncRoles('admin');
        Permission::create(['name' => 'ver_categoria', 'guard_name' => 'web', 'category' => 'Categorias'])->syncRoles('admin');
        Permission::create(['name' => 'ver_cualquier_categoria', 'guard_name' => 'web', 'category' => 'Categorias'])->syncRoles('admin');

        //Permisos "perfil_empresarial"
        Permission::create(['name' => 'crear_perfil_empresarial', 'guard_name' => 'web', 'category' => 'Perfil Empresarial'])->syncRoles('admin');
        Permission::create(['name' => 'editar_perfil_empresarial', 'guard_name' => 'web', 'category' => 'Perfil Empresarial'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_perfil_empresarial', 'guard_name' => 'web', 'category' => 'Perfil Empresarial'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_cualquier_perfil_empresarial', 'guard_name' => 'web', 'category' => 'Perfil Empresarial'])->syncRoles('admin');
        Permission::create(['name' => 'ver_perfil_empresarial', 'guard_name' => 'web', 'category' => 'Perfil Empresarial'])->syncRoles('admin');
        Permission::create(['name' => 'ver_cualquier_perfil_empresarial', 'guard_name' => 'web', 'category' => 'Perfil Empresarial'])->syncRoles('admin');

        //Permisos "Posts"
        Permission::create(['name' => 'crear_post', 'guard_name' => 'web', 'category' => 'Post'])->syncRoles('admin');
        Permission::create(['name' => 'editar_post', 'guard_name' => 'web', 'category' => 'Post'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_post', 'guard_name' => 'web', 'category' => 'Post'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_cualquier_post', 'guard_name' => 'web', 'category' => 'Post'])->syncRoles('admin');
        Permission::create(['name' => 'ver_post', 'guard_name' => 'web', 'category' => 'Post'])->syncRoles('admin');
        Permission::create(['name' => 'ver_cualquier_post', 'guard_name' => 'web', 'category' => 'Post'])->syncRoles('admin');

        //Permisos "registro_acreditacion_certificacion"
        Permission::create(['name' => 'crear_registro_acreditacion_certificacion', 'guard_name' => 'web', 'category' => 'Registro, Acreditación y Certificación'])->syncRoles('admin');
        Permission::create(['name' => 'editar_registro_acreditacion_certificacion', 'guard_name' => 'web', 'category' => 'Registro, Acreditación y Certificación'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_registro_acreditacion_certificacion', 'guard_name' => 'web', 'category' => 'Registro, Acreditación y Certificación'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_cualquier_registro_acreditacion_certificacion', 'guard_name' => 'web', 'category' => 'Registro, Acreditación y Certificación'])->syncRoles('admin');
        Permission::create(['name' => 'ver_registro_acreditacion_certificacion', 'guard_name' => 'web', 'category' => 'Registro, Acreditación y Certificación'])->syncRoles('admin');
        Permission::create(['name' => 'ver_cualquier_registro_acreditacion_certificacion', 'guard_name' => 'web', 'category' => 'Registro, Acreditación y Certificación'])->syncRoles('admin');

        //Permisos "sector_de_experiencia_y_conocimiento"
        Permission::create(['name' => 'crear_sector_de_experiencia_y_conocimiento', 'guard_name' => 'web', 'category' => 'Sector de Experiencia Y Conocimiento'])->syncRoles('admin');
        Permission::create(['name' => 'editar_sector_de_experiencia_y_conocimiento', 'guard_name' => 'web', 'category' => 'Sector de Experiencia Y Conocimiento'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_sector_de_experiencia_y_conocimiento', 'guard_name' => 'web', 'category' => 'Sector de Experiencia Y Conocimiento'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_cualquier_sector_de_experiencia_y_conocimiento', 'guard_name' => 'web', 'category' => 'Sector de Experiencia Y Conocimiento'])->syncRoles('admin');
        Permission::create(['name' => 'ver_sector_de_experiencia_y_conocimiento', 'guard_name' => 'web', 'category' => 'Sector de Experiencia Y Conocimiento'])->syncRoles('admin');
        Permission::create(['name' => 'ver_cualquier_sector_de_experiencia_y_conocimiento', 'guard_name' => 'web', 'category' => 'Sector de Experiencia Y Conocimiento'])->syncRoles('admin');

        //Permisos "tipo_de_membresia"
        Permission::create(['name' => 'crear_tipo_de_membresia', 'guard_name' => 'web', 'category' => 'Tipo De Membresia'])->syncRoles('admin');
        Permission::create(['name' => 'editar_tipo_de_membresia', 'guard_name' => 'web', 'category' => 'Tipo De Membresia'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_tipo_de_membresia', 'guard_name' => 'web', 'category' => 'Tipo De Membresia'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_cualquier_tipo_de_membresia', 'guard_name' => 'web', 'category' => 'Tipo De Membresia'])->syncRoles('admin');
        Permission::create(['name' => 'ver_tipo_de_membresia', 'guard_name' => 'web', 'category' => 'Tipo De Membresia'])->syncRoles('admin');
        Permission::create(['name' => 'ver_cualquier_tipo_de_membresia', 'guard_name' => 'web', 'category' => 'Tipo De Membresia'])->syncRoles('admin');

        //Permisos 'permisos_membresias'
        Permission::create(['name' => 'crear_permiso_membresias', 'guard_name' => 'web', 'category' => 'Permisos De Membresia'])->syncRoles('admin');
        Permission::create(['name' => 'editar_permiso_membresias', 'guard_name' => 'web', 'category' => 'Permisos De Membresia'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_permiso_membresias', 'guard_name' => 'web', 'category' => 'Permisos De Membresia'])->syncRoles('admin');
        Permission::create(['name' => 'ver_permiso_membresias', 'guard_name' => 'web', 'category' => 'Permisos De Membresia'])->syncRoles('admin');
        Permission::create(['name' => 'ver_cualquier_permiso_membresias', 'guard_name' => 'web', 'category' => 'Permisos De Membresia'])->syncRoles('admin');
        
        //Permisos 'videos(testimonios)'
        Permission::create(['name' => 'ver_cualquier_video', 'guard_name' => 'web', 'category' => 'Testimonios'])->syncRoles('admin');
        Permission::create(['name' => 'ver_video', 'guard_name' => 'web', 'category' => 'Testimonios'])->syncRoles('admin');
        Permission::create(['name' => 'crear_video', 'guard_name' => 'web', 'category' => 'Testimonios'])->syncRoles('admin');
        Permission::create(['name' => 'editar_video', 'guard_name' => 'web', 'category' => 'Testimonios'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_video', 'guard_name' => 'web', 'category' => 'Testimonios'])->syncRoles('admin');    
        
        //Permisos 'temas(eventos-posts)'
        Permission::create(['name' => 'ver_cualquier_tema', 'guard_name' => 'web', 'category' => 'Temas'])->syncRoles('admin');
        Permission::create(['name' => 'ver_tema', 'guard_name' => 'web', 'category' => 'Temas'])->syncRoles('admin');
        Permission::create(['name' => 'crear_tema', 'guard_name' => 'web', 'category' => 'Temas'])->syncRoles('admin');
        Permission::create(['name' => 'editar_tema', 'guard_name' => 'web', 'category' => 'Temas'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_tema', 'guard_name' => 'web', 'category' => 'Temas'])->syncRoles('admin');

        //Permisos para Noticias
        Permission::create(['name' => 'ver_cualquier_noticia', 'guard_name' => 'web', 'category' => 'Noticias'])->syncRoles('admin');
        Permission::create(['name' => 'ver_noticia', 'guard_name' => 'web', 'category' => 'Noticias'])->syncRoles('admin');
        Permission::create(['name' => 'crear_noticia', 'guard_name' => 'web', 'category' => 'Noticias'])->syncRoles('admin');
        Permission::create(['name' => 'editar_noticia', 'guard_name' => 'web', 'category' => 'Noticias'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_noticia', 'guard_name' => 'web', 'category' => 'Noticias'])->syncRoles('admin');

        //Permisos para Webinars
        Permission::create(['name' => 'ver_cualquier_webinar', 'guard_name' => 'web', 'category' => 'Webinar'])->syncRoles('admin');
        Permission::create(['name' => 'ver_webinar', 'guard_name' => 'web', 'category' => 'Webinar'])->syncRoles('admin');
        Permission::create(['name' => 'crear_webinar', 'guard_name' => 'web', 'category' => 'Webinar'])->syncRoles('admin');
        Permission::create(['name' => 'editar_webinar', 'guard_name' => 'web', 'category' => 'Webinar'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_webinar', 'guard_name' => 'web', 'category' => 'Webinar'])->syncRoles('admin');

        //Permisos para Prerregistros
        Permission::create(['name' => 'ver_cualquier_prerregistro', 'guard_name' => 'web', 'category' => 'Prerregistros'])->syncRoles('admin');
        Permission::create(['name' => 'ver_prerregistro', 'guard_name' => 'web', 'category' => 'Prerregistros'])->syncRoles('admin');
        Permission::create(['name' => 'crear_prerregistro', 'guard_name' => 'web', 'category' => 'Prerregistros'])->syncRoles('admin');
        Permission::create(['name' => 'editar_prerregistro', 'guard_name' => 'web', 'category' => 'Prerregistros'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_prerregistro', 'guard_name' => 'web', 'category' => 'Prerregistros'])->syncRoles('admin');

        //Permisos para Publicidad Pagada
        Permission::create(['name' => 'ver_cualquier_publicidad_pagada', 'guard_name' => 'web', 'category' => 'Publicidad Pagada'])->syncRoles('admin');
        Permission::create(['name' => 'ver_publicidad_pagada', 'guard_name' => 'web', 'category' => 'Publicidad Pagada'])->syncRoles('admin');
        Permission::create(['name' => 'crear_publicidad_pagada', 'guard_name' => 'web', 'category' => 'Publicidad Pagada'])->syncRoles('admin');
        Permission::create(['name' => 'editar_publicidad_pagada', 'guard_name' => 'web', 'category' => 'Publicidad Pagada'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_publicidad_pagada', 'guard_name' => 'web', 'category' => 'Publicidad Pagada'])->syncRoles('admin');

        //Permisos para faq
        Permission::create(['name' => 'ver_cualquier_faq', 'guard_name' => 'web', 'category' => 'faq'])->syncRoles('admin');
        Permission::create(['name' => 'ver_faq', 'guard_name' => 'web', 'category' => 'faq'])->syncRoles('admin');
        Permission::create(['name' => 'crear_faq', 'guard_name' => 'web', 'category' => 'faq'])->syncRoles('admin');
        Permission::create(['name' => 'editar_faq', 'guard_name' => 'web', 'category' => 'faq'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_faq', 'guard_name' => 'web', 'category' => 'faq'])->syncRoles('admin');

        //Permisos para Bolsa de Trabajo
        Permission::create(['name' => 'ver_cualquier_trabajo', 'guard_name' => 'web', 'category' => 'Bolsa de trabajo'])->syncRoles('admin');
        Permission::create(['name' => 'ver_trabajo', 'guard_name' => 'web', 'category' => 'Bolsa de trabajo'])->syncRoles('admin');
        Permission::create(['name' => 'crear_trabajo', 'guard_name' => 'web', 'category' => 'Bolsa de trabajo'])->syncRoles('admin');
        Permission::create(['name' => 'editar_trabajo', 'guard_name' => 'web', 'category' => 'Bolsa de trabajo'])->syncRoles('admin');
        Permission::create(['name' => 'eliminar_trabajo', 'guard_name' => 'web', 'category' => 'Bolsa de trabajo'])->syncRoles('admin');
    }
}
