<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Post;
use App\Models\User;
use Spatie\Permission\Models\Role as SpatieRole;

class RoleSeeder extends Seeder
{
    public function run()
    {
        // Crear el rol admin si no existe
        $adminRole = SpatieRole::firstOrCreate(
            ['name' => 'admin', 'guard_name' => 'web']
        );

        // Obtener el primer usuario o crear uno si no existe
        $user = User::first();

        if (!$user) {
            $user = User::factory()->create([
                'name' => 'Autor Ejemplo',
                'email' => 'tecolli@carboncluster.com',
                'password' => bcrypt('iso-utf-77-tec-#$'),
            ]);
        }

        // Asignar el rol admin al usuario si no lo tiene
        if (!$user->hasRole('admin')) {
            $user->assignRole($adminRole);
        }

        // Crear publicaciones asociadas al usuario solo si no existen
        if (Post::where('user_id', $user->id)->count() === 0) {
            Post::insert([
                [
                    'title' => 'Primera publicación',
                    'content' => 'Este es el contenido de la primera publicación.',
                    'published_at' => now(),
                    'user_id' => $user->id,
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
                [
                    'title' => 'Segunda publicación',
                    'content' => 'Aquí hay más texto sobre otro tema interesante.',
                    'published_at' => now(),
                    'user_id' => $user->id,
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
            ]);
        }

        // Otros roles, creando solo si no existen
        $roles = [
            'viewer',
        ];

        foreach ($roles as $roleName) {
            SpatieRole::firstOrCreate(
                ['name' => $roleName, 'guard_name' => 'web']
            );
        }
    }
}
