<x-app-layout>
    <div class="container-fluid pt-0">
        <div class="row">
            
            {{-- Contenido principal --}}
            <div class="col-lg-9 col-md-8 col-12">
                <h1 class="mb-4">Ofertas Laborales</h1>

                <div class="pt-3 pb-lg-5 pb-md-4 pb-2">
                    @foreach($ofertas as $oferta)
                        <div class="col-12 mb-3">
                            <div class="card shadow-sm border-0 rounded-3">
                                <div class="row g-0 align-items-center">
                                    
                                    {{-- Columna izquierda (logo empresa) --}}
                                    <div class="col-md-2 d-flex justify-content-center align-items-center p-3">
                                        @if(!empty($oferta->empresas->logo_path))
                                            <img src="{{ asset('storage/' . $oferta->empresas->logo_path) }}" 
                                                 alt="Logo {{ $oferta->empresas->nombre }}" 
                                                 class="img-fluid rounded" 
                                                 style="max-height: 70px; max-width: 100px; object-fit: contain;">
                                        @else
                                            <div class="bg-light d-flex justify-content-center align-items-center rounded" 
                                                 style="width: 70px; height: 70px;">
                                                <i class="bi bi-briefcase fs-3 text-primary"></i>
                                            </div>
                                        @endif
                                    </div>

                                    {{-- Columna derecha (contenido) --}}
                                    <div class="col-md-10">
                                        <div class="card-body">
                                            <h5 class="card-title mb-1">{{ $oferta->puesto }}</h5>
                                            <p class="card-text text-muted mb-2">{{ $oferta->descripcion }}</p>

                                            @if(!is_null($oferta->salario))
                                                <p class="fw-bold text-success mb-1">
                                                    Salario: ${{ number_format($oferta->salario, 2) }}
                                                </p>
                                            @endif

                                            <p class="small mb-0">
                                                Empresa: {{ $oferta->empresas->nombre ?? 'Sin nombre' }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="col-lg-3 col-md-4 col-12">
                <x-partials.sidebar/>
            </div>

        </div>
    </div>
</x-app-layout>
