@php
    use App\Models\PublicidadPagada;
    $publicidades = PublicidadPagada::where('status', true)->get();
@endphp

@if($publicidades->count() > 0)
<div class="carousel-wrapper">
    <div class="carousel-track">
        @foreach($publicidades as $pub)
            <div class="carousel-slide">
                <a href="{{ $pub->link }}">
                <img src="{{ asset('storage/' . $pub->image_path) }}" alt="{{ $pub->titulo }}">
                </a>
            </div>
        @endforeach
    </div>
</div>

<style>
.carousel-wrapper {
    overflow: hidden;
    width: 100%;
    position: relative;
}

.carousel-track {
    display: flex;
    transition: transform 0.5s ease-in-out;
}

.carousel-slide {
    flex: 0 0 calc(100% / 3); /* 3 visibles */
}

.carousel-slide img {
    width: 100%;
    height: 200px;
    object-fit: cover;
    display: block;
}

/* Responsivo: en móviles mostramos 1 */
@media (max-width: 768px) {
    .carousel-slide {
        flex: 0 0 100%;
    }
}
</style>

<script>
    const track = document.querySelector('.carousel-track');
    const slides = document.querySelectorAll('.carousel-slide');
    const visible = 3; // cantidad de slides visibles
    const interval = 6000; // tiempo entre movimientos (3s)

    let isMoving = false;

    function showNextSlide() {
        if (isMoving) return;
        isMoving = true;

        // Mueve 1 slide a la izquierda
        track.style.transition = "transform 0.5s ease-in-out";
        track.style.transform = `translateX(-${100 / visible}%)`;

        // Cuando termina la animación...
        setTimeout(() => {
            // mueve el primer slide al final
            track.appendChild(track.firstElementChild);

            // resetea la posición sin transición
            track.style.transition = "none";
            track.style.transform = "translateX(0)";

            // permite otra animación
            isMoving = false;
        }, 500); // mismo tiempo que la transición
    }

    if (slides.length > visible) {
        setInterval(showNextSlide, interval);
    }
</script>
@endif
