@props([
    'title' => __('Confirm Password'), 
    'content' => __('For your security, please confirm your password to continue.'), 
    'button' => __('Confirm')
])

@php
    $confirmableId = md5($attributes->wire('then'));
@endphp

<!-- Trigger -->
<span
    {{ $attributes->wire('then') }}
    x-data
    x-ref="span"
    x-on:click="$wire.startConfirmingPassword('{{ $confirmableId }}')"
    x-on:password-confirmed.window="setTimeout(() => $event.detail.id === '{{ $confirmableId }}' && $refs.span.dispatchEvent(new CustomEvent('then', { bubbles: false })), 250);"
    class="text-primary fw-semibold cursor-pointer"
>
    {{ $slot }}
</span>

@once
<!-- Modal -->
<x-dialog-modal wire:model.live="confirmingPassword">
    <x-slot name="title">
        <i class="ai-lock-closed text-primary me-2"></i>
        {{ $title }}
    </x-slot>

    <x-slot name="content">
        <p class="text-muted">{{ $content }}</p>

        <div class="mt-3">
            <input type="password"
                   class="form-control w-75"
                   placeholder="{{ __('Password') }}"
                   autocomplete="current-password"
                   x-ref="confirmable_password"
                   wire:model="confirmablePassword"
                   wire:keydown.enter="confirmPassword">

            <x-input-error for="confirmable_password" class="text-danger mt-2" />
        </div>
    </x-slot>

    <x-slot name="footer">
        <div class="d-flex justify-content-end">
            <button class="btn btn-secondary me-2" wire:click="stopConfirmingPassword" wire:loading.attr="disabled">
                {{ __('Cancel') }}
            </button>

            <button class="btn btn-primary" dusk="confirm-password-button" wire:click="confirmPassword" wire:loading.attr="disabled">
                {{ $button }}
            </button>
        </div>
    </x-slot>
</x-dialog-modal>
@endonce
