@props(['id' => null, 'maxWidth' => null])

<x-modal :id="$id" :maxWidth="$maxWidth" {{ $attributes }}>
    <!-- Contenido principal -->
    <div 
        class="px-6 py-4" 
        x-data="{ theme: localStorage.getItem('theme') || 'light' }" 
        :class="theme === 'dark' ? 'bg-dark text-light' : 'bg-light text-dark'">
        <div class="text-lg font-medium" :class="theme === 'dark' ? 'text-light' : 'text-dark'">
            {{ $title }}
        </div>

        <div class="mt-4 text-sm" :class="theme === 'dark' ? 'text-secondary' : 'text-muted'">
            {{ $content }}
        </div>
    </div>

    <!-- Footer -->
    <div 
        class="flex flex-row justify-end px-6 py-4 text-end" 
        x-data="{ theme: localStorage.getItem('theme') || 'light' }" 
        :class="theme === 'dark' ? 'bg-secondary text-light' : 'bg-light text-dark'">
        {{ $footer }}
    </div>
</x-modal>
