<div id="newsletterModal" class="modal-np">
    <div class="modal-contenido">
        <span class="cerrar" onclick="document.getElementById('newsletterModal').style.display='none'">&times;</span>

        <!-- Logo de la empresa -->
        <div class="text-center mb-3">
            <img src="{{ asset('assets/logo.png') }}" alt="Logo" class="img-fluid" style="max-height: 40px;">
        </div>

        <!-- Título -->
        <h2 class="mb-2 titulo-newsletter">Suscríbete a nuestro Newsletter 📩</h2>

        <!-- Beneficios -->
        <p class="beneficios">
            ✅ Recibe novedades exclusivas antes que nadie <br>
            ✅ Accede a descuentos especiales para suscriptores <br>
            ✅ Mantente informado sobre nuestras últimas noticias
        </p>

        <!-- Formulario -->
        <form>
            <input 
                type="email" 
                name="email" 
                placeholder="Ingresa tu correo" 
                required 
                class="input-email"
            >
            <button type="submit" class="btn-submit">Suscribirme</button>
        </form>
    </div>
</div>

<style>
    .modal-np {
        display: none; /* Oculto por defecto */
        position: fixed;
        z-index: 9999;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        /* background: rgba(0,0,0,0.6); */
    }

    .modal-contenido {
        position: absolute;
        top: 50%;
        right: 5%; /* centrado a la derecha */
        transform: translateY(-50%);
        background: #fff;
        padding: 2rem;
        border-radius: 12px;
        width: 380px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.3);
    }

    .cerrar {
        position: absolute;
        top: 10px;
        right: 15px;
        font-size: 24px;
        cursor: pointer;
    }

    .titulo-newsletter {
        color: #747919;
        font-weight: bold;
        text-align: center;
    }

    .beneficios {
        font-size: 14px;
        color: #444;
        margin-bottom: 1.2rem;
    }

    .input-email {
        width: 100%;
        padding: 10px;
        margin-bottom: 1rem;
        border: 1px solid #ccc;
        border-radius: 6px;
    }

    .btn-submit {
        width: 100%;
        padding: 10px;
        background: #747919;
        color: #fff;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        font-weight: bold;
    }

    .btn-submit:hover {
        background: #5c6114;
    }
</style>

<script>
    // Mostrar modal automáticamente después de 5 segundos
    window.addEventListener("load", function() {
        setTimeout(function() {
            document.getElementById("newsletterModal").style.display = "block";
        }, 5000); // 5000 ms = 5 segundos
    });
</script>
