@if ($videos->count())
<style>
    .video-carousel {
        position: relative;
        max-width: 800px;
        margin: auto;
        overflow: hidden;
    }

    .video-slide {
        display: none;
        position: absolute;
        width: 100%;
    }

    .video-slide iframe {
        width: 100%;
        height: 450px;
        border: none;
    }

    input[name="carousel"] {
        display: none;
    }

    input[name="carousel"]:checked + .video-slide {
        display: block;
        position: relative;
    }

    .carousel-controls {
        margin-top: 10px;
        text-align: center;
    }

    .carousel-controls label {
        background-color: #333;
        color: white;
        padding: 0.5rem 1rem;
        cursor: pointer;
        border-radius: 5px;
        user-select: none;
        margin: 0 10px;
    }

    .carousel-nav {
        text-align: center;
        margin-top: 1rem;
    }

    .carousel-nav label {
        display: inline-block;
        width: 12px;
        height: 12px;
        margin: 0 5px;
        background-color: #999;
        border-radius: 50%;
        cursor: pointer;
    }

    .carousel-nav label:hover {
        background-color: #333;
    }
</style>

<div class="video-carousel">
    @foreach ($videos as $index => $video)
        <input type="radio" name="carousel" id="video{{ $index }}" {{ $index === 0 ? 'checked' : '' }}>
        <div class="video-slide">
            <iframe src="{{ $video->youtube_embed_url }}" title="{{ $video->title }}" allowfullscreen></iframe>
        </div>
    @endforeach

    <div class="carousel-controls">
        @foreach ($videos as $index => $video)
            @php
                $prev = $index === 0 ? count($videos) - 1 : $index - 1;
                $next = $index === count($videos) - 1 ? 0 : $index + 1;
            @endphp
            <div class="nav-group" id="nav-{{ $index }}" style="display: {{ $index === 0 ? 'block' : 'none' }}">
                <label for="video{{ $prev }}">← Anterior</label>
                <label for="video{{ $next }}">Siguiente →</label>
            </div>
        @endforeach
    </div>

    <div class="carousel-nav">
        @foreach ($videos as $index => $video)
            <label for="video{{ $index }}"></label>
        @endforeach
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const inputs = document.querySelectorAll('input[name="carousel"]');
        const navGroups = document.querySelectorAll('.nav-group');
        let currentIndex = 0;
        let interval = null;
        let userInteracted = false;

        function updateNavDisplay(index) {
            navGroups.forEach((group, i) => {
                group.style.display = i === index ? 'block' : 'none';
            });
        }

        function startCarousel() {
            interval = setInterval(() => {
                if (userInteracted) return;
                inputs[currentIndex].checked = false;
                currentIndex = (currentIndex + 1) % inputs.length;
                inputs[currentIndex].checked = true;
                updateNavDisplay(currentIndex);
            }, 10000);
        }

        inputs.forEach((input, index) => {
            input.addEventListener('change', () => {
                currentIndex = index;
                userInteracted = true;
                clearInterval(interval);
                updateNavDisplay(currentIndex);
            });
        });

        updateNavDisplay(currentIndex);
        startCarousel();
    });
</script>
@else
    <p class="text-center">No hay videos disponibles.</p>
@endif
