<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
  
<!-- Mirrored from stackbros.in/around/blog-list-sidebar.html by HTTrack Website Copier/3.x [XR&CO'2014], Wed, 23 Apr 2025 16:26:43 GMT -->
<head>
  <!-- Scripts y Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://unpkg.com/cropperjs"></script>
    <meta charset="utf-8">

    <!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    
    <!-- SEO meta tags -->
    <title>Tecolli Carbon Cluster</title>
    <meta name="description" content="Juntos para disminuir nuestra huella de carbono">
    <meta name="keywords" content="bootstrap, business, corporate, coworking space, services, creative agency, dashboard, e-commerce, mobile app showcase, saas, multipurpose, product landing, shop, software, ui kit, web studio, landing, light and dark mode, html5, css3, javascript, gallery, slider, touch, creative">
    <meta name="author" content="StackBros">

    <!-- Webmanifest + Favicon / App icons -->
    <link rel="manifest" href="manifest.json">
    <link rel="icon" type="image/png" href="{{ asset('assets/tecolli-hojita.png') }}" sizes="32x32">
    <link rel="apple-touch-icon" href="{{ asset('assets/tecolli180x180.png') }}">
    
    <!-- Imagen al compartir (Open Graph) -->
    <meta property="og:image" content="{{ asset('assets/tecolli180x180.png') }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="180">
    <meta property="og:image:height" content="180">
        
    <!-- Theme switcher (color modes) -->
    <script src="{{ asset('assets/js/theme-switcher.js') }}"></script>

    <!-- Import Google font (Inter) -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&amp;display=swap" rel="stylesheet" id="google-font">

    <!-- Font icons -->
    <link rel="stylesheet" href="{{ asset('assets/icons/around-icons.min.css') }}">

    <!-- Theme styles + Bootstrap -->
    <link rel="stylesheet" media="screen" href="{{ asset('assets/css/theme.min.css') }}">

    <!-- Page loading styles -->
    <style>
      .page-loading {
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 100%;
        -webkit-transition: all .4s .2s ease-in-out;
        transition: all .4s .2s ease-in-out;
        background-color: #fff;
        opacity: 0;
        visibility: hidden;
        z-index: 9999;
      }
      [data-bs-theme="dark"] .page-loading {
        background-color: #121519;
      }
      .page-loading.active {
        opacity: 1;
        visibility: visible;
      }
      .page-loading-inner {
        position: absolute;
        top: 50%;
        left: 0;
        width: 100%;
        text-align: center;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%);
        -webkit-transition: opacity .2s ease-in-out;
        transition: opacity .2s ease-in-out;
        opacity: 0;
      }
      .page-loading.active > .page-loading-inner {
        opacity: 1;
      }
      .page-loading-inner > span {
        display: block;
        font-family: "Inter", sans-serif;
        font-size: 1rem;
        font-weight: normal;
        color: #6f788b;
      }
      [data-bs-theme="dark"] .page-loading-inner > span {
        color: #fff;
        opacity: .6;
      }
      .page-spinner {
        display: inline-block;
        width: 2.75rem;
        height: 2.75rem;
        margin-bottom: .75rem;
        vertical-align: text-bottom;
        background-color: #d7dde2; 
        border-radius: 50%;
        opacity: 0;
        -webkit-animation: spinner .75s linear infinite;
        animation: spinner .75s linear infinite;
      }
      [data-bs-theme="dark"] .page-spinner {
        background-color: rgba(255,255,255,.25);
      }
      @-webkit-keyframes spinner {
        0% {
          -webkit-transform: scale(0);
          transform: scale(0);
        }
        50% {
          opacity: 1;
          -webkit-transform: none;
          transform: none;
        }
      }
      @keyframes spinner {
        0% {
          -webkit-transform: scale(0);
          transform: scale(0);
        }
        50% {
          opacity: 1;
          -webkit-transform: none;
          transform: none;
        }
      }
    </style>

    <!-- Page loading scripts -->
    <script>
      (function () {
        window.onload = function () {
          const preloader = document.querySelector('.page-loading')
          preloader.classList.remove('active')
          setTimeout(function () {
            preloader.remove()
          }, 1500)
        }
      })()
    </script>
  </head>


  <!-- Body -->
  <body>
   @yield('content')

    <!-- Page loading spinner -->
    <div class="page-loading active">
      <div class="page-loading-inner">
        <div class="page-spinner"></div>
        <span>Cargando...</span>
      </div>
    </div>


    <!-- Page wrapper -->
    <main class="page-wrapper">

      <!-- Navbar. Remove 'fixed-top' class to make the navigation bar scrollable with the page -->
      <header class="navbar navbar-expand-lg fixed-top bg-light">
        <div class="container">

          <!-- Navbar brand (Logo) -->
          <a class="navbar-brand pe-sm-3" href="{{ url('/') }}">
            <span class="text-primary flex-shrink-0 me-2">
              <img src="{{ asset('assets/logo.png') }}" alt="Logo" class="img-fluid" style="max-height: 30px;">
            </span>
          </a>

          <!-- Theme switcher -->
          <div class="form-check form-switch mode-switch order-lg-2 me-3 me-lg-4 ms-auto" data-bs-toggle="mode">
            <input class="form-check-input" type="checkbox" id="theme-mode">
            <label class="form-check-label" for="theme-mode">
              <i class="ai-sun fs-lg"></i>
            </label>
            <label class="form-check-label" for="theme-mode">
              <i class="ai-moon fs-lg"></i>
            </label>
          </div>
        
          <div class="dropdown order-lg-3 d-none d-sm-inline-flex">
    <!-- Mi cuenta: solo si está autenticado -->
    @if(auth()->check())
  
    <a class="btn btn-primary btn-sm fs-sm dropdown-toggle" href="#" role="button" id="accountDropdown" data-bs-toggle="dropdown" aria-expanded="false">
      <i class="ai-user fs-xl me-2 ms-n1"></i>
      Mi cuenta
    </a>

          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="accountDropdown">
                      <li>
                        {{-- Mostrar este botón solo a usuarios admin --}}
                        @if(auth()->user()->hasRole('admin'))
                          <a class="dropdown-item" href="{{ url('admin') }}" role="button">
                            <i class="ai-chart fs-xl me-2 ms-n1"></i>
                            Panel Administrativo
                          </a>
                        @endif
                      </li>

                      <!-- Encabezado -->
                      {{-- <li>
                        <a class="dropdown-header text-muted">{{ __('Manage Account') }}</a>
                      </li> --}}
                      {{-- Apartado administrar perfil --}}
                      <li class="flex">
                        <a class="dropdown-item d-flex align-items-center" href="{{ route('profile.show') }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-gear me-2" viewBox="0 0 16 16">
                          <path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492M5.754 8a2.246 2.246 0 1 1 4.492 0 2.246 2.246 0 0 1-4.492 0"/>
                          <path d="M9.796 1.343c-.527-1.79-3.065-1.79-3.592 0l-.094.319a.873.873 0 0 1-1.255.52l-.292-.16c-1.64-.892-3.433.902-2.54 2.541l.159.292a.873.873 0 0 1-.52 1.255l-.319.094c-1.79.527-1.79 3.065 0 3.592l.319.094a.873.873 0 0 1 .52 1.255l-.16.292c-.892 1.64.901 3.434 2.541 2.54l.292-.159a.873.873 0 0 1 1.255.52l.094.319c.527 1.79 3.065 1.79 3.592 0l.094-.319a.873.873 0 0 1 1.255-.52l.292.16c1.64.893 3.434-.902 2.54-2.541l-.159-.292a.873.873 0 0 1 .52-1.255l.319-.094c1.79-.527 1.79-3.065 0-3.592l-.319-.094a.873.873 0 0 1-.52-1.255l.16-.292c.893-1.64-.902-3.433-2.541-2.54l-.292.159a.873.873 0 0 1-1.255-.52zm-2.633.283c.246-.835 1.428-.835 1.674 0l.094.319a1.873 1.873 0 0 0 2.693 1.115l.291-.16c.764-.415 1.6.42 1.184 1.185l-.159.292a1.873 1.873 0 0 0 1.116 2.692l.318.094c.835.246.835 1.428 0 1.674l-.319.094a1.873 1.873 0 0 0-1.115 2.693l.16.291c.415.764-.42 1.6-1.185 1.184l-.291-.159a1.873 1.873 0 0 0-2.693 1.116l-.094.318c-.246.835-1.428.835-1.674 0l-.094-.319a1.873 1.873 0 0 0-2.692-1.115l-.292.16c-.764.415-1.6-.42-1.184-1.185l.159-.291A1.873 1.873 0 0 0 1.945 8.93l-.319-.094c-.835-.246-.835-1.428 0-1.674l.319-.094A1.873 1.873 0 0 0 3.06 4.377l-.16-.292c-.415-.764.42-1.6 1.185-1.184l.292.159a1.873 1.873 0 0 0 2.692-1.115z"/>
                        </svg>
                         <span>Administrar perfil</span>
                        </a>
                      </li>
                    {{-- Apartado de mis publicaciones --}}
                    {{-- <li class="flex mt-1">
                      <a class="dropdown-item d-flex align-items-center" href="{{ route('user.mis_publicaciones') }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-gear me-2" viewBox="0 0 16 16">
                          <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                          <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z"/>
                        </svg>
                         <span>Mis publicaciones</span>
                        </a>
                    </li> --}}

                      <!-- API Tokens (solo si Jetstream los tiene activados) -->
                      @if (Laravel\Jetstream\Jetstream::hasApiFeatures())
                        <li>
                          <a class="dropdown-item" href="{{ route('api-tokens.index') }}">
                            {{ __('API Tokens') }}
                          </a>
                        </li>
                      @endif

                      <li><hr class="dropdown-divider"></li>

                      <!-- Logout -->
                      <li>
                        <form method="POST" action="{{ route('logout') }}" id="logout-form">
                          @csrf
                          <a class="dropdown-item" href="{{ route('logout') }}" 
                            onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            {{ __('Log Out') }}
                          </a>
                        </form>
                      </li>
                    </ul>
                  
                @else
                  <!-- Mostrar botones si NO está autenticado -->
                  @if (Route::has('login'))
                    <div class="order-lg-3 d-none d-sm-inline-flex ms-3 align-items-center gap-2">

                      <!-- Botón Login -->
                      <a
                        href="{{ route('login') }}"
                        class="btn btn-outline-primary btn-sm d-inline-flex align-items-center gap-1"
                      >
                        <i class="ai-lock"></i> Iniciar sesión
                      </a>

                      @if (Route::has('register'))
                        <!-- Botón Register -->
                        <a
                          href="{{ route('register') }}"
                          class="btn btn-primary btn-sm d-inline-flex align-items-center gap-1"
                        >
                          <i class="ai-user-plus"></i> Registrarse
                        </a>
                      @endif
                    </div>
                  @endif
                @endif

              
            </ul>
          </div>

          <!-- Mobile menu toggler (Hamburger) -->
          <button class="navbar-toggler ms-sm-3" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>

          <!-- Navbar collapse (Main navigation) -->
          <nav class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav navbar-nav-scroll me-auto" style="--ar-scroll-height: 520px;">
              {{-- <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">Plataforma</a>
                <ul class="dropdown-menu">
                  
                  <li><a class="dropdown-item" href="{{ route('dashboard') }}">Inicio</a></li>
                  <li><a class="dropdown-item" href="{{ route('posts.index') }}">Eventos</a></li>
                  
                </ul>
              </li> --}}
              <li class="nav-item dropdown">
                <a class="nav-link" href="{{ route('welcome') }}" >Inicio</a>
              </li>              
              {{-- Menu desplegable de directorio --}}
              <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">Comunidad</a>
                <ul class="dropdown-menu">
                  {{-- Link de empresas (directorio) --}}
                   <li>
                    <a class="dropdown-item" href="{{ route('nuestros-aliados') }}" >Nuestros aliados</a>
                  </li>
                  <li>
                    <a class="dropdown-item" href="{{ route('empresas.index') }}" >Directorio</a>
                  </li>
                  <li>
                    <a class="dropdown-item" href="{{ route('trabajo.index') }}" >Bolsa de trabajo</a>
                  </li>
                </ul>
              </li>
              {{-- Menu desplegable de Informacion --}}
              {{-- <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">Información</a>
                <ul class="dropdown-menu"> --}}
                  {{-- Link de webinars --}}
                  {{-- <li>
                    <a class="dropdown-item" href="{{ route('webinars.index') }}" >Webinars</a>
                  </li>
                </ul>
              </li> --}}
              {{-- Menu desplegable de Newsletters --}}
              <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">Contenido</a>
                <ul class="dropdown-menu">
                  {{-- Link de webinars --}}
                  <li>
                    <a class="dropdown-item" href="{{ route('noticias.index') }}" >Noticias</a>
                  </li>
                  {{-- Link de Eventos --}}
                  <li>
                    <a class="dropdown-item" href="{{ route('posts.index') }}" >Carbon Insights</a>
                  </li>
                  {{-- Link de webinars --}}
                  <li>
                    <a class="dropdown-item" href="{{ route('webinars.index') }}" >Conversando con…</a>
                  </li>
                </ul>
              </li>
              {{-- Menu desplegable de Membresias --}}
              <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">Membresías</a>
                <ul class="dropdown-menu">
                  {{-- Link de membresias --}}
                  <li>
                    <a class="dropdown-item" href="{{ route('empresas.suscripcion') }}" >Conviértete en miembro</a>
                  </li>
                  <li>
                    <a class="dropdown-item" href="{{ route('faq') }}" >FAQ</a>
                  </li>
                </ul>
              </li>
              {{-- Apartado de contactanos --}}
              <li class="nav-item dropdown">
                <a class="nav-link" href="{{ route('contactanos') }}" >Contáctanos</a>
              </li> 

              {{-- <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">Noticias</a>
              </li> --}}
            
            </ul>

        {{-- Solo para usuarios autenticados --}}
            
      {{-- Menú móvil --}}
      <div class="d-sm-none p-3 mt-n3">
        @if(auth()->check())
          {{-- Menú desplegable para usuario autenticado --}}
          <div class="dropdown">
            <a class="btn btn-primary w-100 dropdown-toggle" href="#" id="mobileAccountDropdown" data-bs-toggle="dropdown" aria-expanded="false">
              <i class="ai-user fs-xl me-2 ms-n1"></i>
              Mi cuenta
            </a>

            <ul class="dropdown-menu w-100" aria-labelledby="mobileAccountDropdown">
              <!-- Encabezado -->
              <li><h6 class="dropdown-header text-muted">{{ __('Manage Account') }}</h6></li>

              <!-- Panel Administrativo (solo admin) -->
              @if(auth()->user()->hasRole('admin'))
                <li>
                  <a class="dropdown-item" href="{{ url('admin') }}">
                    <i class="ai-chart fs-xl me-2 ms-n1"></i>
                    Panel Administrativo
                  </a>
                </li>
              @endif

              {{-- <!-- Perfil -->
              <li>
                <a class="dropdown-item" href="{{ route('profile.show') }}">
                  {{ __('Profile') }}
                </a>
              </li> --}}

              {{-- Apartado administrar perfil --}}
                      <li class="flex mt-1">
                        <a class="dropdown-item d-flex align-items-center" href="{{ route('profile.show') }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-gear me-2" viewBox="0 0 16 16">
                          <path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492M5.754 8a2.246 2.246 0 1 1 4.492 0 2.246 2.246 0 0 1-4.492 0"/>
                          <path d="M9.796 1.343c-.527-1.79-3.065-1.79-3.592 0l-.094.319a.873.873 0 0 1-1.255.52l-.292-.16c-1.64-.892-3.433.902-2.54 2.541l.159.292a.873.873 0 0 1-.52 1.255l-.319.094c-1.79.527-1.79 3.065 0 3.592l.319.094a.873.873 0 0 1 .52 1.255l-.16.292c-.892 1.64.901 3.434 2.541 2.54l.292-.159a.873.873 0 0 1 1.255.52l.094.319c.527 1.79 3.065 1.79 3.592 0l.094-.319a.873.873 0 0 1 1.255-.52l.292.16c1.64.893 3.434-.902 2.54-2.541l-.159-.292a.873.873 0 0 1 .52-1.255l.319-.094c1.79-.527 1.79-3.065 0-3.592l-.319-.094a.873.873 0 0 1-.52-1.255l.16-.292c.893-1.64-.902-3.433-2.541-2.54l-.292.159a.873.873 0 0 1-1.255-.52zm-2.633.283c.246-.835 1.428-.835 1.674 0l.094.319a1.873 1.873 0 0 0 2.693 1.115l.291-.16c.764-.415 1.6.42 1.184 1.185l-.159.292a1.873 1.873 0 0 0 1.116 2.692l.318.094c.835.246.835 1.428 0 1.674l-.319.094a1.873 1.873 0 0 0-1.115 2.693l.16.291c.415.764-.42 1.6-1.185 1.184l-.291-.159a1.873 1.873 0 0 0-2.693 1.116l-.094.318c-.246.835-1.428.835-1.674 0l-.094-.319a1.873 1.873 0 0 0-2.692-1.115l-.292.16c-.764.415-1.6-.42-1.184-1.185l.159-.291A1.873 1.873 0 0 0 1.945 8.93l-.319-.094c-.835-.246-.835-1.428 0-1.674l.319-.094A1.873 1.873 0 0 0 3.06 4.377l-.16-.292c-.415-.764.42-1.6 1.185-1.184l.292.159a1.873 1.873 0 0 0 2.692-1.115z"/>
                        </svg>
                         <span>Administrar perfil</span>
                        </a>
                      </li>
                {{-- Apartado de mis publicaciones --}}
                    {{-- <li class="flex mt-1">
                      <a class="dropdown-item d-flex align-items-center" href="{{ route('user.mis_publicaciones') }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-gear me-2" viewBox="0 0 16 16">
                          <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                          <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z"/>
                        </svg>
                         <span>Mis publicaciones</span>
                        </a>
                    </li> --}}

              <!-- API Tokens -->
              @if (Laravel\Jetstream\Jetstream::hasApiFeatures())
                <li>
                  <a class="dropdown-item" href="{{ route('api-tokens.index') }}">
                    {{ __('API Tokens') }}
                  </a>
                </li>
              @endif

              <li><hr class="dropdown-divider"></li>

              <!-- Logout -->
              <li>
                <form method="POST" action="{{ route('logout') }}" id="mobile-logout-form">
                  @csrf
                  <a class="dropdown-item" href="{{ route('logout') }}"
                    onclick="event.preventDefault(); document.getElementById('mobile-logout-form').submit();">
                    {{ __('Log Out') }}
                  </a>
                </form>
              </li>
            </ul>
          </div>
        @else
          {{-- Botones para usuarios no autenticados --}}
          @if (Route::has('login'))
            <div class="d-flex flex-column gap-2">
              <a href="{{ route('login') }}" class="btn btn-outline-primary btn-sm w-100 d-flex align-items-center justify-content-center gap-1">
                <i class="ai-lock"></i> Iniciar sesión
              </a>

              @if (Route::has('register'))
                <a href="{{ route('register') }}" class="btn btn-primary btn-sm w-100 d-flex align-items-center justify-content-center gap-1">
                  <i class="ai-user-plus"></i> Registrarse
                </a>
              @endif
            </div>
          @endif
        @endif
      </div>
          </nav>
        </div>
      </header>
    </main>

    <main>
        {{ $slot }}
    </main>
  <x-partials.footer/>

</html>
