@php
    use App\Models\PublicidadPagada;
    $publicidades = PublicidadPagada::where('status', true)->get();
@endphp

@if($publicidades->count() > 0)
<div id="carruselPublicidad" 
     style="position: relative; width: 100%; aspect-ratio: 16 / 9; overflow: hidden;" 
     class="">
    @foreach($publicidades as $index => $pub)
        <div class="slide" style="
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            transition: opacity 0.5s;
            opacity: {{ $index === 0 ? '1' : '0' }};
        ">
        <a href="{{ $pub->link }}">
            <img src="{{ asset('storage/' . $pub->image_path) }}" 
                 alt="{{ $pub->titulo }}" 
                 style="width:100%; height:100%; object-fit: cover;">
        </a>
        </div>
    @endforeach
</div>


<script>
    const slides = document.querySelectorAll('#carruselPublicidad .slide');
    const tiempos = @json($publicidades->pluck('tiempo'));
    let current = 0;

    function showNextSlide() {
        slides[current].style.opacity = 0;
        current = (current + 1) % slides.length;
        slides[current].style.opacity = 1;

        setTimeout(showNextSlide, tiempos[current] * 1000);
    }

    if(slides.length > 1){
        setTimeout(showNextSlide, tiempos[0] * 1000);
    }
</script>
@endif
