<x-app-layout>
    <style>
  #boton-miembros{
    position: fixed;       /* lo mantiene fijo al hacer scroll */
    top: 90%;              /* centrado vertical */
    right: 20px;            /* separación desde el borde izquierdo */
    transform: translateY(-50%); /* centra exactamente en Y */
    z-index: 1000;         /* para que esté sobre otros elementos */
  }

  .btn-verde {
    background-color: #747919; 
    border: none;
    color: #f0f0f0; 
    font-weight: bold;
    padding: 10px 22px;
    border-radius: 25px;
    box-shadow: 0 4px 10px rgba(116, 121, 25, 0.4);
    transition: transform 0.2s ease, box-shadow 0.2s ease;
    animation: float 2s ease-in-out infinite; /* animación vertical suave */
  }

  @keyframes float {
    0%   { transform: translateY(0); }
    50%  { transform: translateY(-4px); }
    100% { transform: translateY(0); }
  }

  .btn-verde:hover {
    box-shadow: 0 6px 15px rgba(116, 121, 25, 0.6);
    transform: scale(1.05); 
  }
</style>

<div id="boton-miembros">
  <a href="{{ route('empresas.suscripcion') }}" 
     class="btn btn-sm fs-6 btn-verde">
     🌱 Conviértete en miembro
  </a>
</div>
<body>
    <!-- Page wrapper -->
    <main class="page-wrapper">
      <!-- Hero -->
      <section class="bg-light position-relative py-5">
        <div class="container position-relative z-2 py-5 mb-4 mb-sm-5">
          <div class="row pb-5 mb-2 mb-sm-0 mb-lg-3">
            <div class="col-lg-10 col-xl-9">

              <!-- Breadcrumb -->
              <nav aria-label="breadcrumb">
                <ol class="pt-lg-3 pb-lg-4 pb-2 breadcrumb">
                  {{-- <li class="breadcrumb-item">
                    <a href="index.html" class="text-dark">Home</a>
                  </li> --}}
                  <li class="breadcrumb-item active text-dark" aria-current="page">Contáctanos</li>
                </ol>
              </nav>

              <h1 class="display-2 pb-2 pb-sm-3 text-dark">Conecta con nuestra red y sé parte de la acción climática.</h1>

              <ul class="list-unstyled d-flex flex-wrap mb-0">
                <li class="d-flex text-dark py-1 me-4">
                  <i class="ai-check-alt text-primary lead me-2"></i>
                  Directorio especializado
                </li>
                <li class="d-flex text-dark py-1 me-4">
                  <i class="ai-check-alt text-primary lead me-2"></i>
                  Herramientas de vinculación
                </li>
                <li class="d-flex text-dark py-1">
                  <i class="ai-check-alt text-primary lead me-2"></i>
                 Recursos Informativos
                </li>
              </ul>

            </div>
          </div>
        </div>
      </section>



      <!-- About -->
      <section class="container position-relative z-3" style="margin-top: -135px;">
        <div class="rounded-5 overflow-hidden"> 
          <div class="jarallax ratio ratio-16x9" data-jarallax data-speed="0.6">
            <div class="jarallax-img" style="background-image: url(assets/img/about/agency/parallax-image.jpg);"></div>
          </div>
        </div>
<style>
.benefits-section {
  background-color: #8b8c3f;
  color: #fff;
  border-radius: 20px;
  padding: 3rem;
  text-align: center;
}

.section-title {
  font-weight: bold;
  font-size: 2rem;
  margin-bottom: 3rem;
}

.benefits-grid {
  display: grid;
  grid-template-columns: repeat(3, 1fr); /* 3 columnas en desktop */
  gap: 3rem; /* espacio entre columnas y filas */
  justify-items: center;
}

@media (max-width: 992px) {
  .benefits-grid {
    grid-template-columns: repeat(2, 1fr); /* 2 columnas en tablets */
    gap: 2.5rem;
  }
}

@media (max-width: 576px) {
  .benefits-grid {
    grid-template-columns: 1fr; /* 1 columna en móviles */
    gap: 2rem;
  }
}

.benefit-item {
  display: flex;
  flex-direction: row; /* fila en desktop */
  align-items: flex-start;
  gap: 1.5rem; /* espacio entre ícono y texto */
  width: 100%; /* ocupa todo el ancho de la columna */
  max-width: 350px; /* opcional: limita el ancho máximo */
}

@media (max-width: 576px) {
  .benefit-item {
    flex-direction: column;
    align-items: center;
    text-align: center;
    max-width: 100%;
    gap: 1rem;
  }
}

.icon-number {
  display: flex;
  flex-direction: column;
  align-items: center;
  flex-shrink: 0;
}

.icon-number .number {
  font-weight: bold;
  margin-bottom: 0.5rem;
  font-size: 1.2rem;
}

.icon-number svg {
  background-color: orange;
  border-radius: 50%;
  padding: 0.5rem;
  width: 48px;
  height: 48px;
  color: #fff;
}

.benefit-item p {
  margin: 0;
  font-size: 0.95rem;
  line-height: 1.6; /* más separación entre líneas */
  text-align: left; /* más natural */
}
</style>






        {{-- Beneficios --}}
        <h2 class="mt-4">Beneficios de ser parte de Tecolli</h2>
        <section class="benefits-section container py-5">
  <div class="benefits-grid">
    
    <div class="benefit-item" >
      <div class="icon-number" >
        
        
        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-eye-fill" viewBox="0 0 16 16">
          <path d="M10.5 8a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0"/>
          <path d="M0 8s3-5.5 8-5.5S16 8 16 8s-3 5.5-8 5.5S0 8 0 8m8 3.5a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7"/>
        </svg>
      </div>
      <p><b>Visibilidad</b> en un directorio especializado de actores clave del mercado de carbono.</p>
    </div>

    <div class="benefit-item">
      <div class="icon-number">
        
        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-people-fill" viewBox="0 0 16 16">
                <path d="M7 14s-1 0-1-1 1-4 5-4 5 3 5 4-1 1-1 1zm4-6a3 3 0 1 0 0-6 3 3 0 0 0 0 6m-5.784 6A2.24 2.24 0 0 1 5 13c0-1.355.68-2.75 1.936-3.72A6.3 6.3 0 0 0 5 9c-4 0-5 3-5 4s1 1 1 1zM4.5 8a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5"/>
              </svg>
      </div>
      <p><b>Acceso</b> a conexiones estratégicas con clientes, proveedores y aliados del sector.</p>
    </div>

    <div class="benefit-item">
      <div class="icon-number">
        
        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-newspaper" viewBox="0 0 16 16">
                <path d="M0 2.5A1.5 1.5 0 0 1 1.5 1h11A1.5 1.5 0 0 1 14 2.5v10.528c0 .3-.05.654-.238.972h.738a.5.5 0 0 0 .5-.5v-9a.5.5 0 0 1 1 0v9a1.5 1.5 0 0 1-1.5 1.5H1.497A1.497 1.497 0 0 1 0 13.5zM12 14c.37 0 .654-.211.853-.441.092-.106.147-.279.147-.531V2.5a.5.5 0 0 0-.5-.5h-11a.5.5 0 0 0-.5.5v11c0 .278.223.5.497.5z"/>
                <path d="M2 3h10v2H2zm0 3h4v3H2zm0 4h4v1H2zm0 2h4v1H2zm5-6h2v1H7zm3 0h2v1h-2zM7 8h2v1H7zm3 0h2v1h-2zm-3 2h2v1H7zm3 0h2v1h-2zm-3 2h2v1H7zm3 0h2v1h-2z"/>
              </svg>
      </div>
      <p><b>Información</b> actualizada sobre sostenibilidad, mercados de carbono y tendencias globales.</p>
    </div>

    <div class="benefit-item">
      <div class="icon-number">
        
        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-briefcase-fill" viewBox="0 0 16 16">
                <path d="M6.5 1A1.5 1.5 0 0 0 5 2.5V3H1.5A1.5 1.5 0 0 0 0 4.5v1.384l7.614 2.03a1.5 1.5 0 0 0 .772 0L16 5.884V4.5A1.5 1.5 0 0 0 14.5 3H11v-.5A1.5 1.5 0 0 0 9.5 1zm0 1h3a.5.5 0 0 1 .5.5V3H6v-.5a.5.5 0 0 1 .5-.5"/>
                <path d="M0 12.5A1.5 1.5 0 0 0 1.5 14h13a1.5 1.5 0 0 0 1.5-1.5V6.85L8.129 8.947a.5.5 0 0 1-.258 0L0 6.85z"/>
              </svg>
      </div>
      <p><b>Oportunidad</b> de publicar requerimientos, vacantes y ofertas para tu organización.</p>
    </div>

    <div class="benefit-item">
      <div class="icon-number">
        
        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-megaphone-fill" viewBox="0 0 16 16">
                <path d="M13 2.5a1.5 1.5 0 0 1 3 0v11a1.5 1.5 0 0 1-3 0zm-1 .724c-2.067.95-4.539 1.481-7 1.656v6.237a25 25 0 0 1 1.088.085c2.053.204 4.038.668 5.912 1.56zm-8 7.841V4.934c-.68.027-1.399.043-2.008.053A2.02 2.02 0 0 0 0 7v2c0 1.106.896 1.996 1.994 2.009l.496.008a64 64 0 0 1 1.51.048m1.39 1.081q.428.032.85.078l.253 1.69a1 1 0 0 1-.983 1.187h-.548a1 1 0 0 1-.916-.599l-1.314-2.48a66 66 0 0 1 1.692.064q.491.026.966.06"/>
              </svg>
      </div>
      <p><b>Difusión</b> de tu empresa a través de espacios publicitarios y contenido patrocinado dentro de la plataforma.</p>
    </div>

    <div class="benefit-item">
      <div class="icon-number">
        
        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-globe-americas-fill" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="m8 0 .412.01A7.97 7.97 0 0 1 13.29 2a8.04 8.04 0 0 1 2.548 4.382 8 8 0 1 1-15.674 0 8 8 0 0 1 1.361-3.078A8 8 0 0 1 2.711 2 7.96 7.96 0 0 1 8 0m0 1a7 7 0 0 0-5.958 3.324C2.497 6.192 6.669 7.827 6.5 8c-.5.5-1.034.884-1 1.5.07 1.248 2.259.774 2.5 2 .202 1.032-1.051 3 0 3 1.5-.5 3.798-3.186 4-5 .138-1.242-2-2-3.5-2.5-.828-.276-1.055.648-1.5.5S4.5 5.5 5.5 5s1 0 1.5.5c1 .5.5-1 1-1.5.838-.838 3.16-1.394 3.605-2.001A6.97 6.97 0 0 0 8 1"/>
              </svg>
      </div>
      <p><b>Inclusión</b> en la comunidad Tecolli, que promueve la colaboración multisectorial y la innovación.</p>
    </div>

  </div>
</section>

      </section>


      <!-- How we work (Steps) -->
      <section class="container pt-5 mt-1 mt-sm-2 mt-xl-4 mt-xxl-5">
        <div class="row align-items-center pt-2 pt-sm-3 pt-md-4 pt-lg-5 mt-xl-2 mt-xxl-3">
          <div class="col-md-6 col-xl-5 pb-3 pb-md-0 mb-4 mb-md-0">
            <div class="ratio ratio-1x1 d-flex align-items-center position-relative rounded-circle overflow-hidden bg-size-cover mx-auto" style="max-width: 530px; background-image: url(assets/img/about/agency/steps-image.jpg);">
              <div class="bg-black position-absolute top-0 start-0 w-100 h-100 opacity-50"></div>
              <div class="position-relative z-2 p-4" data-bs-theme="dark">
                <div class="text-center mx-auto" style="max-width: 275px;">
                  <span class="d-block text-body fs-sm text-uppercase mb-3">Vinculación efectiva para acelerar la acción climática.</span>
                  <h2 class="display-6 mb-0">Contáctanos</h2>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-6 col-xl-5 offset-xl-1">
  <div class="ps-md-4 ps-xl-0">
    <div class="steps steps-hoverable">
      
      <div class="step py-3 py-xl-4">
        <div class="step-number">
          <div class="step-number-inner">
            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
              <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z"/>
            </svg>
          </div>
        </div>
        <div class="step-body">
          <h3 class="h5 pb-1 mb-2">Correo electrónico</h3>
          <p class="mb-0">conecta@tecollicarboncluster.com</p>
        </div>
      </div>
      
      <div class="step py-3 py-xl-4">
        <div class="step-number">
          <div class="step-number-inner">
            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-telephone" viewBox="0 0 16 16">
              <path d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.6 17.6 0 0 0 4.168 6.608 17.6 17.6 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.68.68 0 0 0-.58-.122l-2.19.547a1.75 1.75 0 0 1-1.657-.459L5.482 8.062a1.75 1.75 0 0 1-.46-1.657l.548-2.19a.68.68 0 0 0-.122-.58zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.68.68 0 0 0 .178.643l2.457 2.457a.68.68 0 0 0 .644.178l2.189-.547a1.75 1.75 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.6 18.6 0 0 1-7.01-4.42 18.6 18.6 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877z"/>
            </svg>
          </div>
        </div>
        <div class="step-body">
          <h3 class="h5 pb-1 mb-2">Teléfono</h3>
          <p class="mb-0">771 192 9429</p>
        </div>
      </div>
      
      {{-- <div class="step py-3 py-xl-4">
        <div class="step-number">
          <div class="step-number-inner">
            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-geo-alt" viewBox="0 0 16 16">
              <path d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A32 32 0 0 1 8 14.58a32 32 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10"/>
              <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4m0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6"/>
            </svg>
          </div>
        </div>
        <div class="step-body">
          <h3 class="h5 pb-1 mb-2">Dirección</h3>
          <p class="mb-0">Pachuca , Hidalgo</p>
        </div>
      </div> --}}
      
      <div class="step py-3 py-xl-4">
        <div class="step-number">
          <div class="step-number-inner">
            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-chat-dots" viewBox="0 0 16 16">
              <path d="M5 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0m4 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0m3 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2"/>
              <path d="m2.165 15.803.02-.004c1.83-.363 2.948-.842 3.468-1.105A9 9 0 0 0 8 15c4.418 0 8-3.134 8-7s-3.582-7-8-7-8 3.134-8 7c0 1.76.743 3.37 1.97 4.6a10.4 10.4 0 0 1-.524 2.318l-.003.011a11 11 0 0 1-.244.637c-.079.186.074.394.273.362a22 22 0 0 0 .693-.125m.8-3.108a1 1 0 0 0-.287-.801C1.618 10.83 1 9.468 1 8c0-3.192 3.004-6 7-6s7 2.808 7 6-3.004 6-7 6a8 8 0 0 1-2.088-.272 1 1 0 0 0-.711.074c-.387.196-1.24.57-2.634.893a11 11 0 0 0 .398-2"/>
            </svg>
          </div>
        </div>
        <div class="step-body">
          <h3 class="h5 pb-1 mb-2">Redes sociales</h3>
          <p class="mb-0">
            <a href="https://www.instagram.com/tecolli_carbon_cluster">Instagram</a> |
            <a href="https://www.tiktok.com/@tecollicarboncluster?is_from_webapp=1&sender_device=pc">Tiktok</a> |
            <a href="https://www.linkedin.com/company/tecolli/about/">LinkedIn</a> | 
            <a href="https://www.youtube.com/@TecolliCarbonCluster">Youtube</a> | 
            <a href="https://www.facebook.com/share/16dQXjrMtL/?mibextid=wwXIfr">Facebook</a>
          </p>
        </div>
      </div>

    </div>
  </div>
</div>

        </div>
      </section>

<style>
  /* Hace que todas las tarjetas sean cuadradas */
.square-card {
  aspect-ratio: 1 / 1; /* moderno, mantiene ancho = alto */
  position: relative;
}

/* Las imágenes ocupan todo el cuadrado sin deformarse */
.square-img {
  width: 100%;
  height: 100%;
  object-fit: cover; /* recorta manteniendo proporción */
  object-position: center;
}

</style>
      <!-- Team -->
      <!-- Team -->
<section class="pt-5 mt-2 mt-xl-4 mt-xxl-5 mb-xl-4">
  <div class="container pt-3 pt-sm-4 pt-lg-5 mt-xl-2 mt-xxl-3">
    <div class="fs-sm text-uppercase mb-3">Nuestro equipo</div>
    <h2 class="display-6 pb-3 mb-lg-4">Somos Tecolli</h2>
    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 g-4">

      <!-- Item -->
      <div class="col">
        <div class="card card-hover border-0 rounded-5 overflow-hidden square-card">
          <img src="{{ asset('assets/guadalupe.png') }}" alt="Image" class="square-img">

          <div class="position-absolute top-0 start-0 w-100 h-100 opacity-0">
            <div class="bg-dark position-absolute top-0 start-0 w-100 h-100 opacity-50"></div>
            <div class="card-body d-flex flex-column justify-content-end h-100 position-relative z-2 text-center" data-bs-theme="dark">
              <h3 class="h5 mb-1">Guadalupe Avendaño</h3>
              <p class="text-body mb-3">Líder Técnica y Socia Fundadora en Tecolli</p>
              <div class="d-flex justify-content-center">
                <a target="_blank" class="btn btn-icon btn-sm btn-light btn-linkedin rounded-circle mx-2" href="https://www.linkedin.com/in/guadalupe-avenda%C3%B1o-5b769928" aria-label="LinkedIn">
                  <i class="ai-linkedin"></i>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Item -->
      <div class="col">
        <div class="card card-hover border-0 rounded-5 overflow-hidden square-card">
          <img src="{{ asset('assets/karla.jpeg') }}" alt="Image" class="square-img">

          <div class="position-absolute top-0 start-0 w-100 h-100 opacity-0">
            <div class="bg-dark position-absolute top-0 start-0 w-100 h-100 opacity-50"></div>
            <div class="card-body d-flex flex-column justify-content-end h-100 position-relative z-2 text-center" data-bs-theme="dark">
              <h3 class="h5 mb-1">Karla Avendaño</h3>
              <p class="text-body mb-3">Diseño de Proyecto y Socia Fundadora en Tecolli</p>
              <div class="d-flex justify-content-center">
                <a target="_blank" class="btn btn-icon btn-sm btn-light btn-linkedin rounded-circle mx-2" href="https://www.linkedin.com/in/karla-avenda%C3%B1o-reyes-tecolli" aria-label="LinkedIn">
                  <i class="ai-linkedin"></i>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>

    </main>
    

    <!-- Back to top button -->
    <a class="btn-scroll-top" href="#top" data-scroll aria-label="Scroll back to top">
      <svg viewBox="0 0 40 40" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
        <circle cx="20" cy="20" r="19" fill="none" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"></circle>
      </svg>
      <i class="ai-arrow-up"></i>
    </a>


    <!-- Vendor scripts: JS libraries and plugins -->
    <script src="assets/vendor/jarallax/dist/jarallax.min.js"></script>
    <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>
    <script src="assets/vendor/lightgallery/lightgallery.min.js"></script>
    <script src="assets/vendor/lightgallery/plugins/fullscreen/lg-fullscreen.min.js"></script>
    <script src="assets/vendor/lightgallery/plugins/zoom/lg-zoom.min.js"></script>

    <!-- Bootstrap + Theme scripts -->
    <script src="assets/js/theme.min.js"></script>
  </body>
</x-app-layout>
