<x-app-layout>
  @php
  $categorias = \App\Models\Categoria::all();
  $rac = \App\Models\RegistroAcreditacionCertificacion::all();
  $sectores = \App\Models\SectoresDeExperienciaConocimiento::all(); 
  @endphp
  
<!-- Page container -->
      <div class="container pt-5 pb-lg-5 pb-md-4 pb-2 my-5">
        
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
          <ol class="pt-lg-3 pb-lg-4 pb-2 breadcrumb">
            {{-- <li class="breadcrumb-item"><a href=" {{ route('dashboard') }} ">Home</a></li> --}}
            <li class="breadcrumb-item active" aria-current="page">Directorio</li>
          </ol>
        </nav>

        <article class="row g-0 border-0 mb-4">

          <!-- Empresas -->
          <div class="col-lg-9 pe-lg-4 pe-xl-5">
            <h3 class="text-decoration-none text-dark">
                Buscar empresa:           
            </h3>
            {{-- BUSCADOR --}}
            <form action="{{ route('perfiles.resultados') }}" method="GET" class="mb-4 row g-3">
                <div class="col-md-3">
                    <input type="text" name="nombre" class="form-control" placeholder="Nombre..." value="{{ request('nombre') }}">
                </div>

                <div class="col-md-3">
                    <select name="categoria_id" class="form-select">
                    <option value="">-- Categoría --</option>
                    @foreach ($categorias as $categoria)
                        <option value="{{ $categoria->id }}" {{ request('categoria_id') == $categoria->id ? 'selected' : '' }}>
                        {{ $categoria->nombre }}
                        </option>
                    @endforeach
                    </select>
                </div>

                <div class="col-md-3">
                    <select name="reg_acr_cer_id" class="form-select">
                    <option value="">-- Certificación --</option>
                    @foreach ($rac as $item)
                        <option value="{{ $item->id }}" {{ request('reg_acr_cer_id') == $item->id ? 'selected' : '' }}>
                        {{ $item->nombre }}
                        </option>
                    @endforeach
                    </select>
                </div>

                <div class="col-md-3">
                    <select name="sector_id" class="form-select">
                    <option value="">-- Sector --</option>
                    @foreach ($sectores as $sector)
                        <option value="{{ $sector->id }}" {{ request('sector_id') == $sector->id ? 'selected' : '' }}>
                        {{ $sector->nombre }}
                        </option>
                    @endforeach
                    </select>
                </div>

                <div class="col-md-12">
                    <button type="submit" class="btn btn-primary">Buscar</button>
                </div>
            </form>

            <h1 class="pb-3 pb-lg-4">Directorio</h1>
            
            <article class="row g-0 border-0 mb-4">
                <!-- empresas list -->
            @foreach ($empresas as $empresa)
            <article class="card border-0  mb-4"> {{-- shadow-sm --}}
                <div class="row g-0">
                    <!-- Logo redondo -->
                    
                        <img src="{{ asset('storage/' . $empresa->logo_path) }}" 
                            alt="Logo {{ $empresa->nombre_comercial }}"
                            class="shadow-sm"
                            style="width: auto; height: 50px; object-fit: cover;">
                    

                    <!-- Info -->
                    <div class="col">
                        <div class="card-body py-3">
                            <h3 class="">
                                <a href="{{ route('empresas.show', $empresa) }}" class="text-decoration-none text-dark">
                                    {{ $empresa->nombre_comercial }}
                                </a>
                            </h3>
                            
                    
                            <p class="mb-1 text-muted">
                                {{ Str::limit($empresa->razon_social, 100) }}
                            </p>
                            <p class="small mb-2">
                                {{ Str::limit($empresa->descripcion_breve, 150) }}
                            </p>

                            <div class="d-flex flex-wrap small text-muted">
                                {{-- <span class="me-3">
                                    <i class="ai-award me-1"></i>
                                    Membresía: {{ $empresa->tipoMembresia->nombre }}
                                </span> --}}
                                <span class="me-3 d-flex align-items-center flex-wrap gap-2">
                                    <i class="ai-user me-1"></i>
                                    Contactos:
                                    @forelse ($empresa->contactosClave->take(3) as $contacto)
                                        <div class="d-flex align-items-center me-3">
                                            <img src="{{ asset('storage/' . $contacto->logo_path) }}"
                                                alt="Logo de {{ $contacto->nombre }}"
                                                class="rounded-circle me-2"
                                                style="width: 32px; height: 32px; object-fit: cover;">
                                            <div class="small">
                                                {{ $contacto->nombre }} {{ $contacto->apellidos }}<br>
                                                <strong>{{ $contacto->puesto_departamento }}</strong>
                                            </div>
                                        </div>
                                    @empty
                                        <em class="ms-2">No registrados</em>
                                    @endforelse
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </article>
            @endforeach

            
            <div class="row gy-3 align-items-center mt-lg-5 pt-2 pt-md-4 pt-lg-0">
              <div class="col-12 d-flex justify-content-center">
                {{ $empresas->links() }}
              </div>
            </div>

            <!-- Links de paginación -->
           <!-- Pagination -->
            <div class="col col-md-4 col-6 order-md-3 order-2">
                <nav aria-label="Page navigation">
                  {{ $empresas->links('pagination::bootstrap-4') }}
                </nav>
              </div>
             
          </div>
          <x-partials.sidebar/>
        </article>
         



</x-app-layout>
